#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <regex.h>
#include <string.h>

int main()
{
    /* regularni izraz koji trazimo u tekstu */
    char pattern[] = "([0-9]+)([.][0-9]*)?";
    /* tekst koji pretrazujemo */
    char text[] = "mirko23.453spasic23442spc234234.sfsf";
    /* pokazivac odakle pocinjemo pretragu */
    char *p = text;
    /* buffer u koji izdvajamo pronadjene podstringove */
    char *substring;

    /* struktura koja je potrebna za pretrazivanje */
    regex_t a;
    /* kod eventualne greske */
    int errcode;
    /* buffer u koji smestamo opis eventualne greske */
    char *errbuf;
    /* niz u kome pamtimo mesto regularnog izraza u tekstu */
    regmatch_t match[3];

    /* spremamo sturkturu pomocu koje mozemo da pretrazujemo teskt */
    errcode = regcomp(&a, pattern, REG_EXTENDED | REG_NEWLINE);
    /* ako je doslo do greske */
    if (errcode != 0) {
	/* odredimo kolika velicina buffer-a nam je potrebna za opis greske koja se desila */
	int errbuf_size = regerror(errcode, &a, NULL, 0);
	/* alociramo toliko memorije */
	if ((errbuf = (char *) malloc(errbuf_size)) == NULL)
	    fprintf(stderr, "Nema dovoljno memorije\n");
	/* upisemo opis greske u pripremljni buffer */
	regerror(errcode, &a, errbuf, errbuf_size);
	/* ispisemo gresku na standardni izlaz za greske */
	fprintf(stderr, "%s\n", errbuf);
	/* neuspesno zavrsimo program */
	exit(EXIT_FAILURE);
    }

    /* pretrazujemo tekst sve dok u njemu postoji trazeni regulatni izraz */
    while (regexec(&a, p, 3, match, 0) == 0) {
	/* ispisujemo gde se trazeni obrazac nalazi u tekstu */
	printf
	    ("Konstanta se nalazi u tekstu, pocevsi od pozicije %d, do pozicije %d\n",
	     match[0].rm_so + p - text, match[0].rm_eo + p - text);
	/* alociramo memoriju i kopiramo ceo trazeni podstring */
	if ((substring =
	     (char *) malloc(match[0].rm_eo - match[0].rm_so + 1)) ==
	    NULL) {
	    fprintf(stderr, "Nema dovoljno memorije\n");
	    exit(EXIT_FAILURE);
	}
	strncpy(substring, p + match[0].rm_so,
		match[0].rm_eo - match[0].rm_so);
	substring[match[0].rm_eo - match[0].rm_so] = '\0';
	printf("To je broj %g\n", atof(substring));

	/* koriramo prvi deo podstringa koji nas interesuje */
	strncpy(substring, p + match[1].rm_so,
		match[1].rm_eo - match[1].rm_so);
	substring[match[1].rm_eo - match[1].rm_so] = '\0';
	printf("Njegov celi deo je %d\n", atoi(substring));

	/* ako postoji drugi deo podstringa koji nas interesuje, kopiramo ga i ispisujemo */
	if (match[2].rm_so != -1) {
	    strncpy(substring, p + match[2].rm_so,
		    match[2].rm_eo - match[2].rm_so);
	    substring[match[2].rm_eo - match[2].rm_so] = '\0';
	    printf("Njegov razlomljeni deo %g\n", atof(substring));
	} else
	    printf("Razlomljeni deo ne postoji, ovo je ceo broj\n");

	/* oslobadjamo alocirano */
	free(substring);

	/* nastavak pretrage nastavljamo od mesta gde se zavrsio trenutni pronadjeni obrazac */
	p += match[0].rm_eo;
    }

    /* oslobadjamo resurse */
    regfree(&a);

    /* uspesno zavrsavamo program */
    return 0;
}
