#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <regex.h>

int main()
{
    /* regularni izraz koji trazimo u tekstu */
    char pattern[] = "a+ba+";
    /* tekst koji pretrazujemo */
    char text[] = "mirkoaaaabaaaspasicaaabaaaspc";
    /* pokazivac odakle pocinjemo pretragu */
    char *p = text;

    /* struktura koja je potrebna za pretrazivanje */
    regex_t a;
    /* kod eventualne greske */
    int errcode;
    /* buffer u koji smestamo opis eventualne greske */
    char *errbuf;
    /* niz u kome pamtimo mesto regularnog izraza u tekstu */
    regmatch_t match[1];

    /* spremamo sturkturu pomocu koje mozemo da pretrazujemo teskt */
    errcode = regcomp(&a, pattern, REG_EXTENDED | REG_NEWLINE);
    /* ako je doslo do greske */
    if (errcode != 0) {
	/* odredimo kolika velicina buffer-a nam je potrebna za opis greske koja se desila */
	int errbuf_size = regerror(errcode, &a, NULL, 0);
	/* alociramo toliko memorije */
	if ((errbuf = (char *) malloc(errbuf_size)) == NULL)
	    fprintf(stderr, "Nema dovoljno memorije\n");
	/* upisemo opis greske u pripremljni buffer */
	regerror(errcode, &a, errbuf, errbuf_size);
	/* ispisemo gresku na standardni izlaz za greske */
	fprintf(stderr, "%s\n", errbuf);
	/* neuspesno zavrsimo program */
	exit(EXIT_FAILURE);
    }

    /* pretrazujemo tekst sve dok u njemu postoji trazeni regulatni izraz */
    while (regexec(&a, p, 1, match, 0) == 0) {
	/* ispisujemo gde se trazeni pbrazac nalazi u tekstu */
	printf("Tekst sadrzi patern\n");
	printf
	    ("Patern se nalazi u tekstu, pocevsi od pozicije %ld, do pozicije %ld\n",
	     match[0].rm_so + p - text, match[0].rm_eo + p - text);
	/* nastavak pretrage nastavljamo od mesta gde se zavrsio trenutni pronadjeni obrazac */
	p += match[0].rm_eo;
    }

    /* oslobadjamo resurse */
    regfree(&a);

    /* uspesno zavrsavamo program */
    return 0;
}
