###########################################################################
###				Zadatak 8				###
###  Na osnovu datoteki predavaci.txt, predmeti.txt i raspoder.txt	###
###  koji imaju zadate strukture, napraviti html dokument koji sadrzi	###
###  tabelu za zadati parametar						###
###########################################################################

# Proveravamo da li je zadat argument komandne linije
if ($#ARGV<0) {
	die "Obavezno zadavanje parametara\n";
}
$param = $ARGV[0];

# Otvaramo za pisanje html datoteku koja se nalazi u podfolderu raspored
open(IZLAZ, ">raspored/".$param.".html") or die "Neuspesno otvaranje datoteke za pisanje\n";
# Pocinjemo u njoj HTML dokument
print IZLAZ "<html>\n<body>\n";

# Ucitamo sve predavace
open(PREDAVACI, "predavaci.txt") or die("Nisam uspeo da otvorim predavaci.txt"); 
while(<PREDAVACI>) {
	if (/(.*)\t(.*)/) {
		$predavaci{$1} = $2;
	}
}
close(PREDAVACI);

# Ucitamo sve predmete
open(PREDMETI, "predmeti.txt") or die("Nisam uspeo da otvorim predmeti.txt"); 
while(<PREDMETI>) {
	if (/(.*)\t(.*)/) {
		$predmeti{$1} = $2;
	}
}
close(PREDMETI);

# Otvaramo fajl raspoded.txt i na osnovu njega pravimo mapu
# ciji su kljucevi dan i vreme, a vrednosti predavac i predmet
open(RASPORED, "raspored.txt") or die "Neuspesno otvaranje rasporeda\n";
while(<RASPORED>) {
	# ako sledeci red u rasporedu ne sadrzi parametar za koji pravimo tabelu sa rasporedom
	# preskacemo ga
	next unless (/$param/);
	if (/(\w+)_(\w+)_(\w+)[.](p|v)_(\w+)_(pon|uto|sre|cet|pet)_(\d+)/) {
		$predavac = $predavaci{$1};
		$grupa = $2;
		$predmet = $predmeti{$3};
		$vrsta = $4;
		$sala = $5;
		$dan = $6;
		$sat = $7;
		$kljuc = $dan.$sat;
		$vrednost = $predavac."<br>".
	 	            $predmet."<br>".
                    $sala;
		$raspored{$kljuc} = $vrednost;
	}
}
# Zatvaramo fajl
close(RASPORED);

@dani = ("pon", "uto", "sre", "cet", "pet");

# Stampamo tabelu u html datodeci
print IZLAZ "<table border = '1'>\n";
for ($sat = 8; $sat <= 20; $sat++) {
	print IZLAZ "<tr><td>$sat</td>";
	foreach $dan (@dani) {
		$kljuc = $dan.$sat;
		$vrednost = $raspored{$kljuc};
		if ($vrednost) {
			print IZLAZ "<td width='120'>$vrednost</td>";
		} else {
			print IZLAZ "<td width='120'>/</td>";
		}
	}
	print IZLAZ "</tr>\n";
}

print IZLAZ "</table>\n";

# Zavrsavamo html daoteku
print IZLAZ "</body>\n</html>\n";

# Zatvaramo datoteku
close(IZLAZ);
