###########################################################################
###			Zadatak 7 (nastavak prethodnog)			###
###  Folder seminarski_radovi je podfolder tekuceg direktorijuma	###
###  U njemu se nalazi fajl indeksi.txt koji je sledeceg formata	###
###  mr07123,Marko Markovic						###
###  mm07124,Mira Miric							###
###  U njemu se nalaze svi studenti					###
###  Pored ovog fajla seminarski_radovi sadrze i podfoldere sa imenima	###
###  koja odgovaraju username-ovima studenata koji su zavrsili		###
###  seminarkse. U svakom od tih foldera se nalazi najvise 5 fajlova	###
###  koji predstavljaju 5 resenih zadataka koliko je trebalo uraditi	###
###  Svaki od tih fajlova moze da se zove 1, 2, 3, 4 ili 5		###
###  sa ekstenzijama .c, .pas ili .java u zavisnosti u kom prog. jeziku	###
###  je redjen zadatak. Studenti su bili slobodni da biraju u kom	###
###  jeziku ce da rade. Zadatak je da se ispisu imena i prezimena	###
###  studenata koji su nesto radili, a u produzetku da se ispise u kom	###
###  jeziku su radili koji zadatak					###
###########################################################################

# Otvaranje datoteke
open (DAT, "seminarski_radovi/indeksi.txt") or die "Neuspesno otvaranje datoteke sa indeksima\n";

# Pamtimo username, imena, prezimena svih studenata u mapu
%indeksi = ();
while(<DAT>) {
	if (/.*,.*/) {
		chomp;
		($a, $b) = split(",", $_);
		$indeksi{$a} = $b;
	}
}

# Zatvaranje datoteke
close(DAT);

# Lista studenata koji su radili seminarski
@studenti = ();

# Mapa svih uradjenih zadataka
# Kljuc mape je indeks na koji je nadovezana _ i broj zadatka
# A vrednost je c, pas, ili java u zavisnosti u cemu je radjen zadatak
%zadaci = ();


# Stampamo ko je predao kakav rad
print "Student\t\t1\t2\t3\t4\t5\t\n";

# Otvaramo direktorijum seminarski_radovi
opendir(DIREKTORIJUM, "seminarski_radovi") or die "nemoguce otvaranje direktorijuma\n";

# Citamo stavku po stavku direktorijuma
while ($stavka = readdir(DIREKTORIJUM)) {
	if ($stavka =~ /m[rvnmil]\d{5}/ && -d "seminarski_radovi/$stavka") {
		# Postavljamo ovog studenta u listu studenata koji su radili seminarski
		push(@studenti, $stavka);
		# Otvaramo direktorijum i gledamo koje zadatke je student uradio
		opendir(PODDIR, "seminarski_radovi/$stavka");
		while ($zad = readdir(PODDIR)) {
			if ($zad =~ /^(\d)\.(c|pas|java)$/) {
				print $stavka."_".$1."\n";
				$zadaci{$stavka."_".$1} =$2;  
			}
		}

		# Zatvaramo direktorijum
		closedir(PODDIR);		
	}
}

# Zatvaramo direktorijum
closedir(DIREKTORIJUM);

# Za svakog studenta koji je radio seminarski ispisujemo koje zadatke je radio u kom jeziku
foreach (@studenti) {
	print "$indeksi{$_}\t";
	for ($i = 1; $i<=5; $i++) {
	    $kljuc = $_."_".$i;
	    if ($zadaci{$kljuc}) {
		print $zadaci{$kljuc}."\t";
	    }
	    else {
		print "-\t";
	    }
	}
	print "\n";
}
