###################################################################
###			Zadatak 5				###
###  Za zadati direktorijum ispisati koje stavke,		###
###  tj. koji fajlovi i poddirektorijumi postoje u njemu.	###
###  Nesto slicno linuks komandi ls				###
###  Ako nije zadat direktorijum kao argument komandne linije	###
###  Ispisati sadrzaj tekuceg direktorijuma.			###
###################################################################

# Gledamo da li postoji argument komandne linije, ili ne
if ($#ARGV<0) {
	$ime_dir = ".";
}
else {
	$ime_dir = $ARGV[0];
}
# Ovo je moglo da se uradi i na sl. nacin
# $ime_dir = $#ARGV=0 ? "." : $ARGV[0];

# Dodajemo na ime direktorijuma / ako je vec ne sadrzi
if (substr($ime_dir, length($ime_dir)-1) ne "/") {
	$ime_dir .= "/";
}


# Otvaranje direktorijuma
opendir (DIREKTORIJUM , $ime_dir) or die "Neuspesno otvaranje.\n";

# Citanje stavki direktorijuma
while ($stavka = readdir(DIREKTORIJUM)) {
	if (-f $ime_dir.$stavka) {
		print "Fajl: $stavka\n";
	}
	elsif (-d $ime_dir.$stavka) {
		print "Direktorijum: $stavka\n";
	}
	elsif (-l $ime_dir.$stavka) {
		print "Simbolicki link: $stavka\n";
	}
}

# Zatvaranje direktorijuma
closedir(DIREKTORIJUM);
