
/******************************************************************
 ***			Zadatak 10				***
 ***	Zadatak prihvata program na C-u, i na osnovu njega	***
 ***	pravi HTML stanicu ciji je sadrzaj samo C-kod, ali	***
 ***	lepo obojen						***
 *****************************************************************/

%option noyywrap

%{
	void stampajznak(char c);
	void stampajstring(char *s);

%}

/*** Regularne definicije  ***/
DIGIT	[0-9]
ID	[a-zA-Z_][a-zA-Z0-9_]*
WHITE	[ \t\n]


%%

{DIGIT}+		{
				/*** Ako naidjemo na celobrojnu konstantu, bojim je u plavu ***/
				fprintf(yyout, "<font color=\"blue\">%s</font>", yytext);
			}
{DIGIT}+\.{DIGIT}*	{
				/*** Ako naidjemo na realnu konstantu, bojimo je u plavo ***/
				fprintf(yyout, "<font color=\"blue\">%s</font>", yytext);
			}
if|else|switch|case|while|for|do|break|continue|int|char|double|float|short|unsigned|long|void|struct|union|static|extern|typedef|return|register	{
				/*** Kljucne reci isticemo ***/
				fprintf(yyout, "<B>%s</B>", yytext);				
			}
^{WHITE}*#(.|\\\n)*\n	{
				/*** Predprocesorske direktive u zeleno ***/
				fprintf(yyout, "<font color=\"green\">");				
				stampajstring(yytext);
				fprintf(yyout, "</font>\n");				
			}
{ID}			{
				/*** Identifikatore u crno ***/
				fprintf(yyout, "<font color=\"black\">%s</font>", yytext);
			}
"/*"([^*]|"*"[^/])*"*/"	{
				/*** Komentare u sivo ***/
				fprintf(yyout, "<font color=\"grey\">");
				stampajstring(yytext);
				fprintf(yyout, "</font>\n");
			}
\"([^\"]|\\\")*\"	{
				/*** Stringove u crveno  ***/
				fprintf(yyout, "<font color=\"red\">");
				stampajstring(yytext);
				fprintf(yyout, "</font>");
			}
.			{
				/*** Sve ostalo samo prepisujemo  ***/
				ECHO;
			}

%%


void stampajznak(char c) {
	if (c=='<')
		fprintf(yyout, "&lt;");
	else if (c=='>')
		fprintf(yyout,"&gt;");
	else if (c=='&')
		fprintf(yyout, "&amp;");
	else
		fprintf(yyout, "%c", c);
}

void stampajstring(char *s) {
	int i;
	for(i=0;s[i]!='\0';i++)
		stampajznak(s[i]);
}



int main(int argc, char* argv[]) {

	/*** U zavisnosti od argumenata komandne linije ***/
	if (argc>1) {
		if ((yyin = fopen(argv[1],"r"))==NULL) {
			fprintf(stderr, "Nepostojeci fajl\n");
			exit(EXIT_FAILURE);
		}
	}
	else
		yyin = stdin;
	if (argc>2) {
		if ((yyout = fopen(argv[2],"w"))==NULL) {
			fprintf(stderr, "Nepostojeci fajl\n");
			exit(EXIT_FAILURE);
		}
	}
	else
		yyout = stdout;

	/*** Stampamo zaglavlje html dokumenta ***/
	fprintf(yyout, "<html>\n");
	if (argc>1)
		fprintf(yyout, "<head><title>%s</title></head>\n", argv[1]);
	fprintf(yyout, "<body><pre>\n");

	/*** Bojimo tekst ***/
	yylex();

	/*** Zavrsavamo html dokument ***/
	fprintf(yyout,"</pre></body></html>\n");


	/*** Zatvaramo fajlove ***/
	fclose(yyin);
	fclose(yyout);

	/*** Zavrsavamo program ***/
	return 0;
}
