/**********************************************************
 ***			Zadatak 8			***
 ***  Napraviti leksicki analizator za mini paskal	***
 ***  koji ce samo da ispisuje koji je lekseme nasao	***
 ***  i koje je tokene prepoznao			***
 ***  Mini paskal sadrzi sve sto je navedeno		***
 ***  u test primeru 08_pascal_scanner.test		***
 *********************************************************/

%option noyywrap

%{
	/*** Ukljucujmo zagalavlje zbog funkcije atof() ***/
	#include <stdlib.h>
	
	#define KLJUC	1
	#define IDEN	2
	#define I_CONST	3
	#define F_CONST	4
	#define OP	5
	#define RO	6
	#define INT	7
	#define OD	8
	#define Z	9
	#define NN	10
%}

/*** Regularne definicije koje nam olaksavaju zapis regularnih izraza ***/
DIGIT	[0-9]
ID	[a-z][a-z0-9]*


%%
{DIGIT}+		{
				return I_CONST;
			}
{DIGIT}+\.{DIGIT}*	{
				return F_CONST;
			}
if|then|begin|end|var|function|integer	{
						return KLJUC;
						}
{ID}			{
				return IDEN;
			}
"+"|"-"|"*"|"/"		{
				return OP;
			}
"<"|">"|"="|"<="|">="	{
				return RO;
			}
":="			{			
				return OD;
			}
[.,:;]			{
				return INT;
			}
"("|")"			{
				return Z;
			}
"{"[^}\n]*"}"		{
				/*** Prazna akicja da bi ignorisali komentare 
				 *** Dozvoljeni su samo jednolinijski komentari radi jednostavnosti
				 ***/
			}
[ \t\n]			{
				/*** I beline ignorisemo ***/
			}
.			{
				/* Sve ostalo su neprepoznati karakteri */
				return NN;
			}

%%


int main(int argc, char* argv[]) {

	int token;
	/*** Ako imamo argumente komandne linije ***/
	if ( argc > 1){
		if (( yyin = fopen(argv[1],"r"))==NULL )
			yyin = stdin;
	}
	else
		yyin = stdin;

	/*** Radimo leksicku analizu   ***/
	while ((token = yylex())!=0) {
		switch(token) {
			case I_CONST:printf("Ceo broj: %d\n",atoi(yytext));break;
			case F_CONST:printf("Realan broj: %f\n",atof(yytext));break;
			case IDEN:printf("Identifikator: %s\n",yytext);break;
			case KLJUC:printf("Kljucna rec: %s\n",yytext);break;
			case OP:printf("Operator: %s\n",yytext);break;
			case RO:printf("Relacioni operator: %s\n",yytext);break;
			case OD:printf("Operator dodele: %s\n",yytext);break;
			case INT:printf("Ingerpunkcija: %s\n",yytext);break;
			case Z:printf("Zagrada: %s\n",yytext);break;
			case NN:fprintf(stderr, "Neprepoznata leksema: %s\n",yytext);exit(EXIT_FAILURE);break;
		}
	}

	/*** Kraj programa ***/
	return 0;
}


