/******************************************************************
***				Zadatak 6			***
***	Zadatak ilustruje kako mozemo da promenimo nacin	***
***	citanja ulaznih podataka				***
***	PS: Ne dolazi na ispitu	 :)				***
******************************************************************/


%option noyywrap

%{
	/*** Promenu nacina citanja mozemo uraditi ako redefinisemo makro YY_INPUT ***/

	/*** Uklanjamo staru definiciju makroa ***/
	#undef YY_INPUT

	/*** Pokazivac na nisku karaktera koja ce predstavljati ulaz  ***/
	char* str_input;

	/*** Definisemo da se cita jedan po jedan karakter niske str_input ***/
	#define YY_INPUT(buf, result, max_size)  {\
		char c = *(str_input++);\
		result = (c=='\0' ? YY_NULL : (buf[0] = c, 1) );\
	} 

%}

%%
	/* Gutamo sve osim slova i cifara koje zelimo da prepisujemo na izlaz */
[a-zA-Z0-9]	{
			/* Prepisujemo sva slova i karaktere */
			ECHO;
		}

.|\n		{
			/* Za sve ostalo je akcija prazna, tj. ne radimo nista, ne prepisujemo ih */
		}

%%


int main() {

	/*** Definisemo ulaz ***/
	str_input = "Ovo je test.\nBroj je 123!\n";

	/*** Radimo leksicnku analizu ***/
	yylex();

	return 0;
}


