/**********************************************************
***			Zadatak 2			***
***	Proverava da li su zagrade lepo uparene		***
***********************************************************
*/

%option noyywrap
%{
	/* Postavljamo broj otvorenih zagrada na 0 */
	int broj_otvorenih = 0;
%}

%%
"{"	{	ECHO; broj_otvorenih++;}
"}"	{
		/* ECHO je isto sto i printf("%s", yytext); */
		ECHO;
		/* Ne smemo zatvarati neotvorenu zagradu */
		if (broj_otvorenih==0) {
			fprintf(stderr, "Nisu lepo uparene zagrade.\n");
			/* Ovaj return se odnosi na fju yylex() */
			return(-1);
		}
		else broj_otvorenih--;
	}
.	{ECHO;}
\n	{ECHO;}
%%

/* Treci deo datoteke se doslovno prenosi u lex.yy.c na sami kraj
 * U njemu cemo napisati main funkciju
 */

int main () {
	/* U kojoj samo pozivamo funkciju yylex() */
	if (yylex()==-1)
		exit(EXIT_FAILURE);

	/* Ako je broj otvorenih zagrada jednak 0, onda su one lepo uparene */
	if (broj_otvorenih==0)
		printf("Zagrade su dobro uparene.\n");
	else 
		printf("Zagrade nisu dobro uparene.\n");

	return 0;
}
