#include <stdio.h>
#include <stdlib.h>

#include "tokeni.h"

int lookahead;

/* #define DEBUG 1 */

extern int yylex();

void Naredba();
void While_naredba();
void If_naredba();
void Blok_naredba();
void Dodela();
void Uslov();
void Niz();
void NizP();

void greska(char *s)
{
    fprintf(stderr, "%s\n", s);
    exit(EXIT_FAILURE);
}

void Naredba()
{
    if (lookahead == WHILE_TOKEN) {
#ifdef DEBUG
	printf("Naredba => While_naredba\n");
#endif
	While_naredba();
    } else if (lookahead == IF_TOKEN) {
#ifdef DEBUG
	printf("Naredba => If_naredba\n");
#endif
	If_naredba();
    } else if (lookahead == ID) {
#ifdef DEBUG
	printf("Naredba => Dodela\n");
#endif
	Dodela();
    } else if (lookahead == BEGIN_TOKEN) {
#ifdef DEBUG
	printf("Naredba => Blok_naredba\n");
#endif
	Blok_naredba();
    } else if (lookahead == END_TOKEN || lookahead == EOI ||
	       lookahead == ';' || lookahead == ELSE_TOKEN) {
#ifdef DEBUG
	printf("Naredba => eps\n");
#endif
    } else
	greska
	    ("Ocekujemo na ulazu while, if, begin, id, end, ;, else ili kraj ulaza");
}

void While_naredba()
{
    if (lookahead == WHILE_TOKEN) {
#ifdef DEBUG
	printf("While_naredba => while Uslov do Naredba\n");
#endif
	lookahead = yylex();
	Uslov();
	if (lookahead != DO_TOKEN)
	    greska("Ocekujemo na ulazu do");
	lookahead = yylex();
	Naredba();
    } else
	greska("Ocekujemo na ulazu while");
}

void If_naredba()
{
    if (lookahead == IF_TOKEN) {
#ifdef DEBUG
	printf("If_naredba => if Uslov then Naredba else Naredba\n");
#endif
	lookahead = yylex();
	Uslov();
	if (lookahead != THEN_TOKEN)
	    greska("Ocekujemo na ulazu then");
	lookahead = yylex();
	Naredba();
	if (lookahead != ELSE_TOKEN)
	    greska("Ocekujemo na ulazu else");
	lookahead = yylex();
	Naredba();
    } else
	greska("Ocekujemo na ulazu if");
}

void Blok_naredba()
{
    if (lookahead == BEGIN_TOKEN) {
#ifdef DEBUG
	printf("Blok_naredba => begin Niz end\n");
#endif
	lookahead = yylex();
	Niz();
	if (lookahead != END_TOKEN)
	    greska("Ocekujemo na ulazu end");
	lookahead = yylex();
    } else
	greska("Ocekujemo na ulazu begin");
}

void Dodela()
{
    if (lookahead == ID) {
#ifdef DEBUG
	printf("Dodela => ID OP_DODELE NUM\n");
#endif
	lookahead = yylex();
	if (lookahead != OP_DODELE)
	    greska("Ocekujemo na ulazu :=");
	lookahead = yylex();
	if (lookahead != NUM)
	    greska("Ocekujemo na ulazu broj");
	lookahead = yylex();
    } else
	greska("Ocekujemo na ulazu id");
}

void Uslov()
{
    if (lookahead == '(') {
#ifdef DEBUG
	printf("Uslov => ( id rel_op num )\n");
#endif
	lookahead = yylex();
	if (lookahead != ID)
	    greska("Ocekujemo na ulazu id");
	lookahead = yylex();
	if (lookahead != REL_OP)
	    greska("Ocekujemo na ulazu relacioni operator");
	lookahead = yylex();
	if (lookahead != NUM)
	    greska("Ocekujemo na ulazu broj");
	lookahead = yylex();
	if (lookahead != ')')
	    greska("Ocekujemo na ulazu )");
	lookahead = yylex();
    } else
	greska("Ocekujemo na ulazu (");
}

void Niz()
{
    if (lookahead == WHILE_TOKEN || lookahead == IF_TOKEN ||
	lookahead == BEGIN_TOKEN || lookahead == ID ||
	lookahead == ';' || lookahead == END_TOKEN) {
#ifdef DEBUG
	printf("Niz => Naredba Niz'\n");
#endif
	Naredba();
	NizP();
    } else
	greska("Ocekivano je na ulazu while, if, begin, id, ; ili end");
}

void NizP()
{
    if (lookahead == ';') {
#ifdef DEBUG
	printf("Niz' => ; Naredba Niz'\n");
#endif
	lookahead = yylex();
	Naredba();
	NizP();
    } else if (lookahead == END_TOKEN) {
#ifdef DEBUG
	printf("Niz' => eps\n");
#endif
    } else
	greska("Ocekujemo na ulazu ; ili end");
}


int main()
{
    lookahead = yylex();
    Naredba();

    if (lookahead != EOI)
	greska("Visak tokena na ulazu");

    printf("Paskal naredba je ispravna\n");

    return 0;
}
