%option noyywrap
%{
#include <stdio.h>
#include <stdlib.h>
#include "tokeni.h"


%}

%%
while   { return WHILE_TOKEN; }
if      { return IF_TOKEN; }
else    { return ELSE_TOKEN; }
then    { return THEN_TOKEN; }
begin   { return BEGIN_TOKEN; }
end     { return END_TOKEN; }
do      { return DO_TOKEN; }
[a-zA-Z_][a-zA-Z_0-9]*   { return ID; }
[0-9]+  { return NUM; }
[<>]    { return REL_OP; }
:=      { return OP_DODELE; }
[;()]   { return *yytext; }
[ \n\t] { }
.       {
          fprintf(stderr, "Leksicka greska, neprepoznat karakter '%c'\n", *yytext);
          exit(EXIT_FAILURE);
        }

%%




