#include <iostream>
#include <vector>
#include <string>

using namespace std;

class Pitalica
{
public:
	virtual ~Pitalica()
		{}
	virtual void Postavi() = 0;
	virtual int Izvestaj( ostream& ) const = 0;
	virtual Pitalica* Kopija() const = 0;
};

class TekstualnaPitalica : public Pitalica
{
public:
	TekstualnaPitalica( const string& s )
		: _TekstPitanja(s)
		{}
		
	void Postavi()
		{
		cout << _TekstPitanja << endl
			 << "--------------------------------------------" << endl
			 << "Upisite odgovor u jednom redu ili znak '@' ako ne znate:"
			 << endl;
		cin >> ws;
		getline( cin, _Odgovor );
		}
		
	int Izvestaj( ostream& ostr ) const
		{
		// prevazilazenje problema sa neispravnom bibliotekom
		// (neophodno da bi program funkcionisao prilikom
		// kompajliranja sa borlandovim kompajlerom
		// u Visual Studio-u dovoljno je uporediti)
		// _Odgovor == "@"
		string s = "@@";
		s[1] = 0;
		
		if( _Odgovor == "s" ){
			ostr << "(-1) Nije odgovoreno.";
			return -1;
			}
		else{
			ostr << "( ? ) Odgovoreno je: " << _Odgovor;
			return 0;
			}
		}
		
	Pitalica* Kopija() const
		{ return new TekstualnaPitalica(*this); }
		
private:
	string _TekstPitanja;
	string _Odgovor;
};

class Test
{
public:
	Test()
		{
		_Pitanja.push_back( new TekstualnaPitalica(
			"Koliko stonoga ima nogu?"
			));
		_Pitanja.push_back( new TekstualnaPitalica(
			"Sta je to stolica?"
			));
		}

	Test( const Test& t )
		{ init(t); }

	~Test()
		{ deinit(); }
		
	Test& operator = ( const Test& t )
		{ 
		if( this != &t ){
			deinit();
			init(t); 
			}
		return *this;
		}

	void Postavi()
		{
		for( unsigned i=0; i<_Pitanja.size(); i++ ){
			cout << endl
				 << "*** Pitanje br. " << (i+1) << " ***" 
				 << endl << endl;
			_Pitanja[i]->Postavi();
			cout << endl;
			}
		}
		
	void Izvestaj( ostream& ostr ) const
		{
		int suma = 0;
		ostr << "Rezultat testiranja:" << endl
			 << "-----------------------------------------" << endl;
		for( unsigned i=0; i<_Pitanja.size(); i++ ){
			ostr << (i+1) << ".  ";
			suma += _Pitanja[i]->Izvestaj( ostr );
			ostr << endl;
			}
		ostr << "-----------------------------------------" << endl
			 << "Rezultat: " << suma << " poena" << endl;
		}

private:
	void deinit()
		{
		for( unsigned i=0; i<_Pitanja.size(); i++ )
			delete _Pitanja[i];
		_Pitanja.clear();
		}

	void init( const Test& t )
		{
		for( unsigned i=0; i<t._Pitanja.size(); i++ )
			_Pitanja.push_back( t._Pitanja[i]->Kopija() );
		}

	vector<Pitalica*> _Pitanja;	
};

main()
{
	Test t;
	t.Postavi();
	cout << endl << endl << endl;
	t.Izvestaj(cout);
	
	return 0;
}

