#include <iostream>

using namespace std;

class Razlomak
{
public:
	Razlomak( int b = 0, int i = 1 )
		: _Brojilac(b),
		  _Imenilac(i)
	{}

	int Imenilac() const
		{ return _Imenilac; }
	int Brojilac() const 
		{ return _Brojilac; }

	void Ispisi( ostream& ostr ) const
		{ ostr << _Brojilac << '/'<< _Imenilac; }

	void Citaj( istream& istr )
		{ 
		char c;
		istr >> _Brojilac >> c >> _Imenilac; 
		}

	Razlomak operator + ( const Razlomak& y ) const
		{
		return Razlomak(
			Brojilac() * y.Imenilac() + Imenilac() * y.Brojilac(),
			Imenilac() * y.Imenilac()
			);
		}

	Razlomak operator - ( const Razlomak& y ) const
		{
		return Razlomak(
			Brojilac() * y.Imenilac() - Imenilac() * y.Brojilac(),
			Imenilac() * y.Imenilac()
			);
		}

	Razlomak operator * ( const Razlomak& y ) const
		{
		return Razlomak(
			Brojilac() * y.Brojilac(),
			Imenilac() * y.Imenilac()
			);
		}

	Razlomak operator / ( const Razlomak& y ) const
		{
		return Razlomak(
			Brojilac() * y.Imenilac(),
			Imenilac() * y.Brojilac()
			);
		}

	Razlomak operator - () const
		{ return Razlomak( -Brojilac(), Imenilac() ); }

	Razlomak operator ~ () const
		{ return Razlomak( Imenilac(), Brojilac() ); }

	bool operator < ( const Razlomak& x ) const 
		{ return Brojilac() * x.Imenilac() < Imenilac() * x.Brojilac(); }

	bool operator == ( const Razlomak& x ) const
		{ return Brojilac() * x.Imenilac() == Imenilac() * x.Brojilac(); }
/*
	bool operator == ( const Razlomak& x ) const
		{ return !( *this < x ) && !( x < *this ); }
*/

	bool operator > ( const Razlomak& x ) const 
		{ return x < *this; }

	bool operator != ( const Razlomak& x ) const
		{ return !( *this == x ); }

	bool operator >= ( const Razlomak& x ) const
		{ return !( *this < x ); }

	bool operator <= ( const Razlomak& x ) const
		{ return !( *this > x ); }

	Razlomak& operator ++ () 
		{
		_Brojilac += _Imenilac;
		return *this; 
		}

	Razlomak operator ++ ( int ) 
		{
		Razlomak y = *this;
		_Brojilac += _Imenilac;
		return y; 
		}

	Razlomak& operator -- () 
		{
		_Brojilac -= _Imenilac;
		return *this; 
		}

	Razlomak operator -- ( int ) 
		{
		Razlomak y = *this;
		_Brojilac -= _Imenilac;
		return y; 
		}

private:
	int _Imenilac;
	int _Brojilac;
};

ostream& operator << ( ostream& ostr, const Razlomak& r )
{
	r.Ispisi(ostr);
	return ostr;
}

istream& operator >> ( istream& istr, Razlomak& r )
{
	r.Citaj(istr);
	return istr;
}

main()
{
	Razlomak a(4,5);
	Razlomak b(3,4);
	
	cout << a << " + " << b << " = " << (a+b) << endl;
	cout << a << " + " << b << " = " << a.operator+(b) << endl;

	cout << a << " - " << b << " = " << (a-b) << endl;
	cout << a << " * " << b << " = " << (a*b) << endl;
	cout << a << " / " << b << " = " << (a/b) << endl;
	
	cout << "-" << a << " = " << (-a) << endl;
	cout << "~" << a << " = " << (~a) << endl;
	cout << ( a + b * b - (~a+a) ) << endl;

	cout << ( a + b == b + a ? "true" : "false" )<< endl;

	// problemi
	cout << ~Razlomak() << endl;
	cout << (Razlomak(3,-4) < Razlomak(2,4)) << endl;

	cout << (a++) << endl;
	cout << a << endl;
	cout << (++a) << endl;
	cout << a << endl;

	return 0;
}



