#include <vector>
#include <string>
#include <iostream>

using namespace std;

//------------------------------------------------------
//	"bibliotecke" funkcije
unsigned lib_SirinaTeksta( string tekst, string fontname, unsigned size );
unsigned lib_VisinaTeksta( string tekst, string fontname, unsigned size );

//------------------------------------------------------
class Element
{
public:
	Element( unsigned s, unsigned v )
		: _Sirina(s), _Visina(v)
		{}
	unsigned Sirina() const
		{ return _Sirina; }
	unsigned Visina() const
		{ return _Visina; }
protected:
	unsigned _Sirina;
	unsigned _Visina;
};

//------------------------------------------------------
class Rec : public Element
{
public:
	Rec( string tekst, string font, unsigned velFonta )
		: Element(
			lib_SirinaTeksta( tekst + " ", font, velFonta ),
			lib_VisinaTeksta( tekst + " ", font, velFonta )
			),
		  _Tekst( tekst ),
		  _Font( font ),
		  _VelFonta( velFonta )
		{}
private:
	string _Tekst;
	string _Font;
	unsigned _VelFonta;
};

//------------------------------------------------------
class Red : public Element
{
public:
	Red( unsigned maxSirina )
		: Element( 0, 1 ), 
		  _MaxSirina( maxSirina )
		{}
	// stavljamo u red sto vise elemenata niza (koliko stane)
	// pri cemu pocinjemo od elementa el[prvi]
	// i vracamo indeks prvog elementa koji nije stao u red
	// (pretpostavljamo da je prvi < el.size())
	unsigned PopuniRed( const vector<const Element*> el, unsigned prvi )
		{
		unsigned sledeci = prvi;
		do Dodaj( el[sledeci++] );
		while(
			sledeci < el.size()
			&& el[sledeci]->Sirina() <= _MaxSirina - Sirina()
			);
		return sledeci;
		}		
	//	dodajemo element za koji pretpostavljamo da ima mesta
	void Dodaj( const Element* e )
		{
		_Elementi.push_back( e );
		_Sirina += e->Sirina();
		_Visina = max( _Visina, e->Visina() );
		}
private:
	unsigned 				_MaxSirina;
	vector<const Element*>	_Elementi;
};

//------------------------------------------------------
// probna implementacija
unsigned lib_SirinaTeksta( string tekst, string fontname, unsigned size )
	{ return tekst.length() * size; }
unsigned lib_VisinaTeksta( string tekst, string fontname, unsigned size )
	{ return size * 2; }

//------------------------------------------------------
main()
{
	vector<const Element*> tekst;
	tekst.push_back( new Rec( "prva", "arial", 10 ));
	tekst.push_back( new Rec( "druga", "arial", 10 ));
	tekst.push_back( new Rec( "treca", "arial", 10 ));
	tekst.push_back( new Rec( "cetvrta", "arial", 10 ));
	
	Red red(120);
	int sledeci = red.PopuniRed( tekst, 0 );
	cout << sledeci << endl;
	cout << red.Sirina() << " " << red.Visina() << endl;
	
	Red red2(120);
	sledeci = red2.PopuniRed( tekst, sledeci );
	cout << sledeci << endl;
	cout << red2.Sirina() << " " << red2.Visina() << endl;

	return 0;
}
