#include <iostream>
#include <math.h>
#include <fstream>

using namespace std;

double arcsin( double x )
{
	if ( x < -1 || x > 1 )
		throw "arcsin: argument nije u intervalu [-1 1].";
	return asin( x );
}

double arccos( double x )
{
	if ( x < -1 || x > 1 )
		throw "arccos: argument nije u intervalu [-1 1].";
	return acos( x );
}

double log(double a, double b)
	{
	if (b <=0)
		throw "log: argument mora biti pozitivan.";
	if (a<=0 || a==1)
		throw "log: osnova mora biti pozitivna i razlicita od jedan.";
	return log(b)/log(a);
	}

double koren(double x)
{
	if (x<0)
		throw "koren: potkorena velicina mora biti nenegativna!!!";
	return sqrt(x);
}

double JedanKrozIks(double x)
{
	if (x==0)
		throw "JedanKrozIks: imenilac ne sme biti nula!!!";
	return 1/x;
}

main()
{
	double x, y;

	ifstream Ulaz("ulaz.txt");
	ofstream Izlaz("izlaz.txt");

	while (1)
		{
		Ulaz >> x;
		if (!Ulaz) break;
		try
			{
			double y = arccos(x);
			Izlaz <<"arccos("<<x<<") = "<<y<<endl;
			}
		catch(const char *s)
			{
			Izlaz << "Greska za x = "<< x <<": "<< s << endl;
			}
	
		try
			{
			double y = arcsin(x);
			Izlaz <<"arcsin("<<x<<") = "<<y<<endl;
			}
		catch(const char *s)
			{
			Izlaz << "Greska za x = "<< x <<": "<< s << endl;
			}
		
		try
			{
			double y = koren(x);
			Izlaz <<"koren("<<x<<") = "<<y<<endl;
			}
		catch(const char *s)
			{
			Izlaz << "Greska za x = "<< x <<": "<< s << endl;
			}
		
		try
			{
			double y = JedanKrozIks(x);
			Izlaz <<"JedanKrozIks("<<x<<") = "<<y<<endl;
			}
		catch(const char *s)
			{
			Izlaz << "Greska za x = "<< x <<": "<< s << endl;
			}
		
		try
			{
			Ulaz >> y;
			if (!Ulaz) throw "Nema dovoljno argumenata u datoteci za log!";
			double z = log(x,y);
			Izlaz <<"log("<<x<<","<<y<<") = "<<z<<endl;
			}
		catch(const char *s)
			{
			Izlaz << "Greska: " << s << endl;
			}


	}

Ulaz.close();
Izlaz.close();

return 0;
}
