
// Resenje kolege Slavka Moconje.
// Primer dopuniti operatorima -, +=, -=, unarno -, *, *=

#include <iostream>
#include <vector>

using namespace std;

#define max(a,b) ((a)<(b))?(b):(a)
#define min(a,b) ((a)<(b))?(a):(b)

class Polinom
{
public:
	Polinom()
	{
		m_Koeficijenti.push_back(0);
	}
	
	Polinom(const vector<double>& koeficijenti)
	{
		unsigned n = koeficijenti.size();
		m_Koeficijenti.resize(n);
		for(unsigned i = 0; i < n; i++)
			m_Koeficijenti[i] = koeficijenti[i];
	}

	Polinom(const Polinom& p)
	{
		unsigned n = p.Stepen();
		m_Koeficijenti.resize(n);
		for(unsigned i = 0; i < n; i++)
			m_Koeficijenti[i] = p.m_Koeficijenti[i];
	}
	
	~Polinom()
	{
		m_Koeficijenti.clear();
	}

	unsigned Stepen() const
	{
		return m_Koeficijenti.size();
	}

	ostream& Ispis(ostream& ostr)const
	{
		for(unsigned i = 0; i < Stepen(); i++)
			ostr << m_Koeficijenti[i] << '*' << "x^" << i << '+' ;
		ostr << "\b ";
		ostr << endl;
		return ostr;
	}

	Polinom operator +(const Polinom& p)const
	{
		unsigned n = Stepen();
		unsigned m = p.Stepen();
		unsigned l = min(n, m); 
		unsigned k = max(n, m); 
		
		vector<double> v;
		v.resize(k);
		unsigned i;

		for(i = 0; i < l; i++)
			v[i] = m_Koeficijenti[i]+p.m_Koeficijenti[i];

		for( ; i < k; i++)
			if(i < n)
				v[i] = m_Koeficijenti[i];
			else
				v[i] = p.m_Koeficijenti[i];

		return Polinom(v);
	}


private:
	vector<double> m_Koeficijenti;
};

ostream& operator <<(ostream& ostr, const Polinom& p)
{
	return p.Ispis(ostr);	
}

main()
{
	vector<double> v;
	v.push_back(1);
	v.push_back(1);
	v.push_back(1);
	v.push_back(1);

	vector<double> w;
	w.push_back(1); 
	w.push_back(4);

	Polinom p(v), q(w);
	
	cout << p << q << (p+q) << endl;

	return 0;
}

/*
1*x^0+1*x^1+1*x^2+1*x^3
1*x^0+4*x^1
2*x^0+5*x^1+1*x^2+1*x^3
*/