#include <iostream>

using namespace std;

class Niz
{
public:
	Niz()
		: _Elementi( 0 ),
		  _Alocirano( 0 ),
		  _Velicina( 0 )
		{}

	~Niz()
		{ delete [] _Elementi; }

	Niz( const Niz& n )
		{ init(n); }

	Niz& operator = ( const Niz& n )
		{ 
		if( this != &n ){
			delete [] _Elementi;			
			init(n); 
			}
		return *this;
		}
		
	int& operator[] ( unsigned i )
		{ 
		if( i >= Velicina() )
			PromeniVelicinu( i + 1 );
		return _Elementi[i]; 
		}
		
	unsigned Velicina() 
		{ return _Velicina; }
	
	// ovo stavljamo samo radi provere
	unsigned Alocirano() 
		{ return _Alocirano; }
		
	void PromeniVelicinu( unsigned v )
		{
		if( v != _Velicina ){
			if( v >= _Alocirano ){
				_Alocirano = v * 1.5;
				if( _Alocirano < 16 )
					_Alocirano = 16;
				/* alternativni algoritam povecavanja niza					
				while( _Alocirano <= v )
					_Alocirano *= 2;
				*/				
				int* noviNiz = new int[_Alocirano];
				for( unsigned i=0; i<_Velicina; i++ )
					noviNiz[i] = _Elementi[i];
				delete [] _Elementi;
				_Elementi = noviNiz;
				}
			else if( v * 1.5 < _Alocirano ){
				_Alocirano = v;
				int* noviNiz = 
					_Alocirano > 0 
						? new int[_Alocirano]
						: 0;
				for( unsigned i=0; i<_Velicina && i<v; i++ )
					noviNiz[i] = _Elementi[i];
				delete [] _Elementi;
				_Elementi = noviNiz;
				}
			_Velicina = v;
			}
		}
		
	void DodajNaKraj( int x )
		{ (*this)[_Velicina] = x; }
		
	void ObrisiSaKraja()
		{ 
		if( _Velicina )
			_Velicina--;
		}
		
	int Poslednji()
		{
		return _Velicina
			? _Elementi[_Velicina-1]
			: 0;
		}	

private:
	void init( const Niz& n )
		{
		_Velicina = n._Velicina;
		_Alocirano = _Velicina;
		_Elementi = new int[_Alocirano];
		for( unsigned i=0; i<_Velicina; i++ )
			_Elementi[i] = n._Elementi[i];
		}

	int* 		_Elementi;
	unsigned	_Velicina;
	unsigned	_Alocirano;
};

class Stack
{
public:
	int Top()
		{ return n.Poslednji(); }			
	void Pop()
		{ n.PromeniVelicinu( n.Velicina() - 1 ); }
	void Push( int x )
		{ n.DodajNaKraj( x ); }
	bool Empty()
		{ return n.Velicina() == 0; }
private:
	Niz n;
};

main()
{
	Stack s;
	for( int i=0; i<10; i++ )
		s.Push(i);
	while( !s.Empty() ){
		cout << s.Top() << endl;
		s.Pop();
		}
	return 0;		
}



