// Resenje 3:
template <class tVrednost>
class Matrica
{
public:
    Matrica(){}
    Matrica( int i, int j )
    {
        _Elementi.resize( i );
        for( int k=0; k<i; k++ )
            _Elementi[k].resize(j);
    }

    Matrica( int i, int j, const tVrednost& t )
        {
        _Elementi.resize( i );
        for( int k=0; k<i; k++ ){
            _Elementi[k].resize(j);
            for( int l=0; l<j; l++ )
                _Elementi[k][l] = t;
            }
        }

    vector<tVrednost>& operator[] ( unsigned i )
        { return _Elementi[i]; }

    const vector<tVrednost>& operator[] ( unsigned i ) const
        { return _Elementi[i]; }

    int DimenzijaX() const
    {return _Elementi.size();}

    int DimenzijaY() const
    {return _Elementi.size() ? _Elementi[0].size() : 0;}


private:
    vector< vector<tVrednost> > _Elementi;
};

template <class tVrednost>
class D3Matrica
{
public:

    D3Matrica(){}

    D3Matrica(int i, int j, int k)
    {
        for (int l=0; l < i; l++)
            _Elementi.push_back(Matrica<tVrednost>(j,k));
    }

    D3Matrica(int i, int j, int k, const tVrednost& t)
    {
        for (int l=0; l < i; l++)
            _Elementi.push_back(Matrica<tVrednost>(j,k,t));
    }

    Matrica<tVrednost>& operator[] ( unsigned i )
    {return _Elementi[i];}

    const Matrica<tVrednost>& operator[] ( unsigned i ) const
    {return _Elementi[i];}

    int DimenzijaX() const
    {return _Elementi.size();}

    int DimenzijaY() const
    {return _Elementi.size() ? _Elementi[0].DimenzijaX() : 0;}

    int DimenzijaZ() const
    {return _Elementi.size() ? _Elementi[0].DimenzijaY() : 0;}

private:
    vector< Matrica<tVrednost> > _Elementi;
};