//Resenje 2: Marko Manojlovic
#include <iostream>

using namespace std;

template <class tVrednost>
class Matrica3D
{
public:
    Matrica3D(int s, int v, int d):
         _Elementi(new tVrednost**[s]),
         _Sirina(s), _Visina(v), _Debljina(d)
    {
        for (int i = 0; i < s; i++)
            _Elementi[i] = new tVrednost*[v];
        for (int i = 0; i < s; i++)
            for (int j = 0; j < v; j++)
                _Element[i][j] = new tVrednost[d];
    }
    Matrica3D(int s, int v, int d, tVrednost t):
         _Elementi(new tVrednost**[s]),
         _Sirina(s), _Visina(v), _Debljina(d)
    {
        for (int i = 0; i < s; i++)
            _Elementi[i] = new tVrednost*[v];
        for (int  i = 0; i < s; i++)
            for (int j = 0; j < v; j++)
                _Elementi[i][j] = new tVrednost[d];
        for (int  i = 0; i < s; i++)
            for (int j = 0; j < v; j++)
                for (int k = 0; k < d; k++)
                    _Elementi[i][j][k] = t;
    }
    Matrica3D(const Matrica3D &m):
         _Elementi(new tVrednost**[m.Sirina()]),
         _Sirina(m.Sirina()), _Visina(m.Visina()), _Debljina(m.Debljina())
    {
        for (int i = 0; i < m.Sirina(); i++)
            _Elementi[i] = new tVrednost*[m.Visina()];
        for (int  i = 0; i < m.Sirina(); i++)
            for (int j = 0; j < m.Visina(); j++)
                _Elementi[i][j] = new tVrednost[m.Debljina()];
        for (int  i = 0; i < m.Sirina(); i++)
            for (int j = 0; j < m.Visina(); j++)
                for (int k = 0; k < m.Debljina(); k++)
                    _Elementi[i][j][k] = m[i][j][k];
    }
    Matrica3D& operator = (const Matrica3D &m)
    {
        if (this != &m)
        {
            for (int i = 0; i < _Sirina; i++)
            {
                for (int j = 0; j < _Visina; j++)
                    delete [] _Elementi[i][j];
                delete [] _Elementi[i];
            }
            delete [] _Elementi;
            _Sirina = m.Sirina();
            _Visina = m.Visina();
            _Debljina = m.Debljina();
            _Elementi = new tVrednost**[m.Sirina()];
            for (int  i = 0; i < m.Sirina(); i++)
            {
                _Elementi[i] = new tVrednost*[m.Visina()];
                for (int j = 0; j < m.Visina(); j++)
                {
                    _Elementi[i][j] = new tVrednost[m.Debljina()];
                    for (int k = 0; k < m.Debljina(); k++)
                        _Elementi[i][j][k] = m[i][j][k];
                }
            }
        }
        return *this;
    }
    ~Matrica3D()
    {
        for (int i = 0; i < _Sirina; i++)
        {
            for (int j = 0; j < _Visina; j++)
                delete [] _Elementi[i][j];
            delete [] _Elementi[i];
        }
        delete [] _Elementi;
    }
    tVrednost** operator [] (unsigned i)
    {
        return _Elementi[i];
    }
    const tVrednost** operator [] (unsigned i) const
    {
        return (const tVrednost**)_Elementi[i];
    }
    unsigned Sirina() const
    {
        return _Sirina;
    }
    unsigned Visina() const
    {
        return _Visina;
    }
    unsigned Debljina() const
    {
        return _Debljina;
    }
private:
    tVrednost ***_Elementi;
    int _Sirina, _Visina, _Debljina;
};

int main()
{
    Matrica3D<int> m(3,3,3,1);
    Matrica3D<int> m1(m);
    Matrica3D<int> m2(4,4,4,3);
    for (int i = 0; i < m.Sirina(); i++)
    {
        for (int j = 0; j < m.Visina(); j++)
        {
            for (int k = 0; k < m.Debljina(); k++)
                cout << m[i][j][k] << ' ';
            cout << endl;
        }
        cout << endl;
    }
    for (int  i = 0; i < m1.Sirina(); i++)
    {
        for (int j = 0; j < m1.Visina(); j++)
        {
            for (int k = 0; k < m1.Debljina(); k++)
                cout << m1[i][j][k] << ' ';
            cout << endl;
        }
        cout << endl;
    }

    m2 = m;
    for (int  i = 0; i < m2.Sirina(); i++)
    {
        for (int j = 0; j < m2.Visina(); j++)
        {
            for (int k = 0; k < m2.Debljina(); k++)
                cout << m2[i][j][k] << ' ';
            cout << endl;
        }
        cout << endl;
    }
    return 0;
}