#include <iostream>
#include <vector>

using namespace std;

template <class tVrednost>
class Matrica
{
public:
	Matrica( int s, int v )
		: _Elementi( new tVrednost[s*v] ),
		  _Sirina(s),
		  _Visina(v)
		{}
		
	Matrica( int s, int v, tVrednost t )
		: _Elementi( new tVrednost[s*v] ),
		  _Sirina(s),
		  _Visina(v)
		{
		for( int k=0; k<s; k++ )
			for( int l=0; l<v; l++ )
				(*this)[k][l] = t;
		}
		
	Matrica( const Matrica& m )
		: _Elementi( new tVrednost[m._Sirina*m._Visina] ),
		  _Sirina(m._Sirina),
		  _Visina(m._Visina)
		{ memcpy( _Elementi, m._Elementi, _Sirina * _Visina * sizeof(tVrednost) ); } 
		
	~Matrica()
		{ delete [] _Elementi; }
		
	Matrica& operator = ( const Matrica& m )
		{ 
		if( this != &m ){
			delete [] _Elementi;
			memcpy( _Elementi, m._Elementi, _Sirina * _Visina * sizeof(tVrednost) );
			}
		return *this;
		} 
		
	tVrednost& Element( unsigned i, unsigned j )
		{ return _Elementi[ i*_Visina + j ]; }

	const tVrednost& Element( unsigned i, unsigned j ) const 
		{ return _Elementi[ i*_Visina + j ]; }

	tVrednost* operator[] ( unsigned i )
		{ return _Elementi + i * _Visina; }

	const tVrednost* operator[] ( unsigned i ) const
		{ return _Elementi + i * _Visina; }
		
private:
	tVrednost* 	_Elementi;
	unsigned 	_Sirina, _Visina;
};

main()
{
	Matrica<int> m(10,20);
	for( int i=0; i<10; i++ )
		for( int j=0; j<20; j++ )
			m[i][j] = i+j;
			
	for( int v=0; v<20; v++ ){
		for( int s=0; s<10; s++ )
			cout << m.Element(s,v) << ' ';
		cout << endl;
		}
			
	return 0;
}

