#include <iostream>
#include <vector>

using namespace std;

template <class tVrednost>
class Matrica
{
public:
	Matrica( int i, int j )
		{
		_Elementi.resize( i );
		for( int k=0; k<i; k++ )
			_Elementi[k].resize(j);
		}
		
	Matrica( int i, int j, tVrednost t )
		{
		_Elementi.resize( i );
		for( int k=0; k<i; k++ ){
			_Elementi[k].resize(j);
			for( int l=0; l<j; l++ )
				_Elementi[k][l] = t;
			}
		}
		
	vector<tVrednost>& operator[] ( unsigned i )
		{ return _Elementi[i]; }

	const vector<tVrednost>& operator[] ( unsigned i ) const
		{ return _Elementi[i]; }
		
private:
	vector< vector<tVrednost> > _Elementi;
};

// osnova za dalju upotrebu grafa
template <class tVrednost>
class Graf
{
private:
	class Cvor
	{
	public:
		Cvor( const tVrednost& v )
			: _Vrednost(v)
			{}
	
		tVrednost _Vrednost;
	};
	
	class Poteg
	{
	public:
		Poteg( unsigned o, unsigned d )
			: _od(o), 
			  _do(d)
			{}
	
		unsigned _od, _do;
	};
	
public:
	Graf( unsigned n )
		: _MaxVelicina( n ),
		  _Potezi( n, n, false )
		{}
		
	void DodajCvor( const tVrednost& v )
		{ 
		if( _Cvorovi.size() >= _MaxVelicina )
			throw "Dodaje se previse cvorova u graf.";
		_Cvorovi.push_back( Cvor(v) ); 
		}
		
	void DodajPoteg( unsigned o, unsigned d )
		{ _Potezi[o][d] = true; }
		
	bool PostojiNeposredanPut( unsigned o, unsigned d )
		{ return _Potezi[o][d]; }

private:
	unsigned		_MaxVelicina;
	vector<Cvor> 	_Cvorovi;
	Matrica<bool>	_Potezi;
};

main()
{
	Graf<int> g(20);
	g.DodajCvor( 1 );
	g.DodajCvor( 2 );
	g.DodajPoteg( 0, 1 );
	
}

