#include <iostream>

using namespace std;

class ElementListe
{
public:
	ElementListe( int v, ElementListe* s=0 )
		: Vrednost(v),
		  Sledeci(s)
		{}
		
	int				Vrednost;
	ElementListe*	Sledeci;
};

class Lista
{
public:
	Lista()
		: _Pocetak(0)
		{}
		
	~Lista()
		{ deinit(); }
		
	Lista( const Lista& l )
		{ init( l ); }
		
	Lista& operator = ( const Lista& l )
		{
		if( &l != this ){
			deinit(); 
			init( l ); 
			}
		return *this;
		}
		
	void DodajNaPocetak( int n )
		{ _Pocetak = new ElementListe( n, _Pocetak ); }
		
	void DodajNaKraj( int n )
		{
		ElementListe* novi = new ElementListe( n );
		if( !_Pocetak )
			_Pocetak = novi;
		else{
			ElementListe* p;
			for( p = _Pocetak; p->Sledeci; p = p->Sledeci )
				;
			p->Sledeci = novi;
			}
		}
		
	int Element( int n ) const
		{
		ElementListe* p = _Pocetak;
		for( int i=0; i<n; i++ )
			p = p->Sledeci;
		return p->Vrednost;
		}
		
private:
	void init( const Lista& l )
		{
		if( l._Pocetak ){
			_Pocetak = new ElementListe( l._Pocetak->Vrednost );
			ElementListe* stari = l._Pocetak;
			ElementListe* novi = _Pocetak;
			while( stari->Sledeci ){
				novi->Sledeci = new ElementListe( stari->Sledeci->Vrednost );
				stari = stari->Sledeci;
				novi = novi->Sledeci;
				}
			}
		else
			_Pocetak = 0;
		}
		
	void deinit()
		{
		for( ElementListe* p = _Pocetak; p; ){
			ElementListe* pl = p->Sledeci;
			delete p;
			p = pl;
			}
		}

	ElementListe* _Pocetak;
};

main()
{
	Lista l;
	for( int i=0; i<10; i++ )
		l.DodajNaPocetak(i);
		
	for( int i=0; i<10; i++ )
		cout << l.Element(i) << ' ';
	cout << endl;
	
	Lista l1 = l;
	for( int i=0; i<10; i++ )
		cout << l1.Element(i) << ' ';
	cout << endl;

	l1 = l;
	for( int i=0; i<10; i++ )
		cout << l1.Element(i) << ' ';
	cout << endl;

	return 0;
}




