#include <iostream>
#include <fstream>
#include <vector>

using namespace std;


//-----------------------------------------------------------
template <class T>
class Matrica
{
public:
	Matrica()
		{}
		
	Matrica( unsigned s, unsigned v )
		: _Podaci(s)
		{
		for( unsigned i=0; i<s; i++ )
			_Podaci[i].resize(v);
		}
		
	const vector<T>& operator[] ( unsigned i ) const
		{ return _Podaci[i]; }
		
	vector<T>& operator[] ( unsigned i )
		{ return _Podaci[i]; }
		
	unsigned Sirina() const
		{ return _Podaci.size(); }
		
	unsigned Visina() const
		{ return _Podaci.size() ? _Podaci[0].size() : 0; }
		
private:
	vector< vector<T> > _Podaci;
};

//-----------------------------------------------------------
class Jedinka;
class Tabla : public Matrica<Jedinka*>
{
public:
	Tabla( int s, int v )
		: Matrica<Jedinka*>(s,v)
		{}
		
	Tabla()
		: Matrica<Jedinka*>()
		{}		

	int BrojSuseda( int x, int y );
};


//-----------------------------------------------------------
class Jedinka
{
public:
	virtual bool Prezivljava( const Tabla& tabla, int& x, int& y ) = 0;
	virtual Jedinka* NovaJedinka();
	virtual char Izgled() const = 0;
};


//-----------------------------------------------------------
class Cekalica : public Jedinka
{
public:
	bool Prezivljava( const Tabla& tabla, int& x, int& y )
		{
		int bs = tabla.BrojSuseda( x, y );
		return bs>=2 && bs<=3;
		}
	Jedinka* NovaJedinka()
		{ return this; }
	char Izgled() const
		{ return 'x'; }
};
Cekalica cekalica;

//-----------------------------------------------------------
class Setalica : public Jedinka
{
public:
	bool Prezivljava( const Tabla& tabla, int& x, int& y )
		{ return true; } 
	Jedinka* NovaJedinka()
		{ return this; }
	char Izgled() const
		{ return 's'; }
};
Setalica setalica;

//-----------------------------------------------------------
class PraznoPolje : public Jedinka
{
public:
	bool Prezivljava( const Tabla& tabla, int& x, int& y )
		{
		int bs = tabla.BrojSuseda( x, y );
		return bs==3;
		}

	Jedinka* NovaJedinka()
		{
		int r = random(100);
		Jedinka* p;
		if( r<50 ) 
			p = &setalica;
		else
			p = &cekalica;
		return p;
		}
		
	char Izgled() const
		{ return '.'; }
};
PraznoPolje praznoPolje;

//-----------------------------------------------------------
int Tabla::BrojSuseda( int x, int y )
{
	int bs = 0;
	int sirina = Sirina();
	int visina = Visina();
	for( int i=-1; i<=1; i++ )
		for( int j=-1; j<=1; j++ )
			if( i || j ){
				int xx = (x+i+sirina) % sirina;
				int yy = (y+j+visina) % visina;
				if( (*this)[xx][yy] != &praznoPolje )
					bs++;
			}
	return bs;
}

//-----------------------------------------------------------
class IgraLife
{
public:
	IgraLife()
		{}
		
	Jedinka* NovaJedinka( char c )
		{
		switch( c ){
			case 's': 
				return &setalica;
			case 'x':
				return &cekalica;
			default:
				return &praznoPolje;
			}
		}
		
	void Iteracija()
		{
		int sirina = _Tabla.Sirina();
		int visina = _Tabla.Visina();
		Tabla novaTabla( sirina, visina );
		for( int i=0; i<sirina; i++ )
			for( int j=0; j<visina; j++ )
				novaTabla[i][j] = 0;
		
		for( int i=0; i<sirina; i++ )
			for( int j=0; j<visina; j++ ){
				int x = i;
				int y = j;
				Jedinka* a = _Tabla[x][y];
				if( a->Prezivljava(_Tabla,x,y) )
					novaTabla[x][y] = a->NovaJedinka();
				else
					novaTabla[i][j] = &praznoPolje;
			}
		_Tabla = novaTabla;
		}
		
	void Ucitaj( istream& istr )
		{
		int sirina, visina;
		istr >> sirina >> visina;
		_Tabla = Tabla( sirina, visina );
		for( int i=0; i<visina; i++ )
			for( int j=0; j<sirina; j++ ){
				char c;
				istr >> c;
				_Tabla[j][i] = NovaJedinka(c);
			}
		}
		
	void Zapisi( ostream& ostr ) const
		{
		int sirina = _Tabla.Sirina();
		int visina = _Tabla.Visina();
				
		ostr << sirina << ' ' << visina << endl;
		for( int i=0; i<visina; i++ ){
			for( int j=0; j<sirina; j++ )
				ostr << _Tabla[j][i]->Izgled();
			ostr << endl;
			}
		}
	
private:
	Tabla _Tabla;
};


istream& operator >> ( istream& istr, IgraLife& igra )
{
	igra.Ucitaj( istr );
	return istr;
}

ostream& operator << ( ostream& ostr, const IgraLife& igra )
{
	igra.Zapisi( ostr );
	return ostr;
}


//-----------------------------------------------------------
main()
{
	IgraLife igra;
	ifstream f( "life.dat");
	f >> igra;
	cout << igra;
	while(1){
		char c = cin.get();
		if( c=='k')
			break;
		igra.Iteracija();
		cout << igra;
	}
	return 0;	
}

