#include <iostream>
#include <math.h>
#define Pi 3.1415

using namespace std;

class Kompleks
{
public:

	Kompleks (double r=0, double i=0) : _Re(r),_Im(i)
	{}

	double Re() const
	{ return _Re; }

	double Im() const
	{ return _Im; }

	double Ro() const 
	{return this->Moduo();}

	double Fi() const 
	{
	if (Re())  return atan(Im()/Re());
	else return Im()<0 ? -Pi/2 : Pi/2;
	}

	double Moduo () const 
	{
	return sqrt(Re()*Re()+Im()*Im());
	}

	Kompleks operator +(const Kompleks& c) const
	{
	return Kompleks(Re() + c.Re(), Im() + c.Im());
	}

	Kompleks operator -(const Kompleks& c) const
	{
	return Kompleks( Re() - c.Re(), Im() - c.Im() );
	}

	Kompleks operator *(const Kompleks& c) const
	{
	return Kompleks( Re() * c.Re() - Im() * c.Im(), Re() * c.Im() + Im() * c.Re());
	}

	Kompleks operator * (const double d) const 
	{
	return Kompleks (Re()*d,Im()*d);
	}

	Kompleks operator /(const Kompleks& c) const
	{
	return Kompleks( (Re() * c.Re() + Im() * c.Im())/(c.Re() * c.Re() + c.Im() * c.Im())
	,(Im() * c.Re() - Re() * c.Im())/(c.Re() * c.Re() + c.Im() * c.Im()));
	}

	Kompleks operator ~() const
	{
	return Kompleks(Re() , -Im());
	}

	istream& Citaj (istream &ul) 
	{
	char c, i;
	ul >> _Re >> c >> _Im >> i;
	if (c=='-')
		_Im=-_Im;
	return ul;
	}

	ostream& Pisi (ostream &izl) const 
	{
	char c = Im()<0 ? '-' : '+';
	return izl <<Re() << c << abs(Im()) << 'i';
	}

private:
	double _Re;
	double _Im;

};

istream& operator >> (istream& str, Kompleks& c)
{ return c.Citaj(str);}

ostream& operator << (ostream& str, const Kompleks& c)
{ return c.Pisi(str); }

main ()
{
Kompleks c1(2,5);
Kompleks c2(4);
Kompleks c3;

cout << "Uneti Kompleks broj u obliku \"a+bi\" :\n";
cin >> c3;
cout << endl;
cout << "Uneli ste sledeci Kompleks broj : \n";
cout << c3 << endl;
cout << "c1+c2=" << (c1+c2) <<" zbir" << endl;
cout << "c2*c3=" << (c2*c3) <<" proizvod" << endl;
cout << "~c1=" << (~c1) << " Konjugovan c1" << endl;
cout << "c1/c3=" << (c1/c3) << " Kolicnik" << endl;
return 0;
}
