/* Marko Manojlovic, Ana Rili i Milena VJ. */
 
#include <iostream>

using namespace std;

class Instrument
{
public:
	static int Brojac;
	Instrument()
	{
		Brojac++;
		cout << "Instrument() " << Brojac << ' ';
	}
	virtual ~Instrument()
	{
		Brojac--;
		cout << " ~Instrument() " << Brojac << endl;
	}
	virtual char* ImeInstrumenta() const = 0;
	virtual char* TipInstrumenta() const = 0;
	virtual char* Sviraj() const = 0;
	virtual char* NastimujSe() const = 0;
	virtual bool ImaZice() const
	{
		return false;
	}
	virtual bool ImaDugmice() const
	{
		return false;
	}
	virtual bool ImaUdaraljke() const
	{
		return false;
	}
	virtual bool OsnovaOdMetala() const
	{
		return false;
	}
	virtual bool OsnovaOdPlastike() const
	{
		return false;
	}
	virtual bool OsnovaOdDrveta() const
	{
		return false;
	}
	void Ispisi(ostream& ostr) const
	{
		ostr << endl<< endl<< ImeInstrumenta();
		ostr << " je ";
		ostr << TipInstrumenta(); 
		ostr << endl << "\t" <<
		(ImaZice() ? "ima " : "nema ") << "zice, " << endl << "\t"<<
		(ImaDugmice() ? "ima " : "nema ") << "dugmice, " << endl << "\t"<<
		(ImaUdaraljke() ? "ima " : "nema ") << "udaraljke, " << endl << "\t"<<
		(OsnovaOdMetala() ? "ima " : "nema ") << "osnovu od metala, " << endl << "\t"<<
		(OsnovaOdPlastike() ? "ima " : "nema ") << "osnovu od plastike, " << endl << "\t"<<
		(OsnovaOdDrveta() ? "ima " : "nema ") << "osnovu od drveta.\n";
	}
};

int Instrument::Brojac = 0;

class ZicaniInstrument: public Instrument
{
public:
	ZicaniInstrument()
	{
		cout << "ZicaniInstrument() ";
	}
	~ZicaniInstrument()
	{
		cout << " ~ZicaniInstrument()";
	}
	char* TipInstrumenta() const
	{
		return "zicani instrument";
	}
	bool ImaZice() const
	{
		return true;
	}

};

class Violina: public ZicaniInstrument
{
public:
	Violina()
	{
		cout << "Violina()" << endl;
	}
	~Violina()
	{
		cout << " ~Violina()" ;
	}
	char* ImeInstrumenta() const
	{
		return "Violina";
	}
	char* Sviraj() const
	{
		return "Violina: cigu - ligu";
	}
	bool OsnovaOdDrveta() const
	{
		return true;
	}
	char* NastimujSe() const
	{
		return "Violina: shkriiiiiiip, shkriiiiip";
	}
};

class Viola: public ZicaniInstrument
{
public:
	Viola()
	{
		cout << "Viola()" << endl;
	}
	~Viola()
	{
		cout << " ~Viola()";
	}
	char* ImeInstrumenta() const
	{
		return "Viola";
	}
	char* Sviraj() const
	{
		return "Viola: CIGU - LIGU";
	}
	bool OsnovaOdDrveta() const
	{
		return true;
	}
	char* NastimujSe() const
	{
		return "Viola: shkriiiiiiip, shkriiiiip";
	}

};

class Violoncelo: public ZicaniInstrument
{
public:
	Violoncelo()
	{
		cout << "Violoncelo()" << endl;
	}
	~Violoncelo()
	{
		cout << " ~Violoncelo()";
	}
	char* ImeInstrumenta() const
	{
		return "Violoncelo";
	}

	char* NastimujSe() const
	{
		return "Violoncelo: shkriiiiiiip, shkriiiiip";
	}
	char* Sviraj() const
	{
		return "Violoncelo: CIGU - ligu";
	}
	bool OsnovaOdDrveta() const
	{
		return true;
	}
};

class Kontrabas: public ZicaniInstrument
{
public:
	Kontrabas()
	{
		cout << "Kontrabas()" << endl;
	}
	~Kontrabas()
	{
		cout << " ~Kontrabas()";
	}
	char* ImeInstrumenta() const
	{
		return "Kontrabas";
	}
	char* Sviraj() const
	{
		return "Kontrabas: CIIIIIGUUUU - LIIIIGUUUU";
	}
	char* NastimujSe() const
	{
		return "Kontrabas: SHKRIIIIP, SHKRIIIP";
	}
	bool OsnovaOdDrveta() const
	{
		return true;
	}
};

class Harfa: public ZicaniInstrument
{
public:
	Harfa()
	{
		cout << "Harfa()" << endl;
	}
	~Harfa()
	{
		cout << " ~Harfa()";
	}
	char* ImeInstrumenta() const
	{
		return "Harfa";
	}
	char* Sviraj() const
	{
		return "Harfa: zdronc";
	}
	char* NastimujSe() const
	{
		return "Harfa: zdhfguyunc";
	}
	bool OsnovaOdMetala() const
	{
		return true;
	}
};

class Gitara: public ZicaniInstrument
{
public:
	Gitara()
	{
		cout << "Gitara()" << endl;
	}
	~Gitara()
	{
		cout << " ~Gitara()";
	}
	char* ImeInstrumenta() const
	{
		return "Gitara";
	}
	char* Sviraj() const
	{
		return "Gitara: tra-la-la";
	}
	char* NastimujSe() const
	{
		return "Gitara: zdhfguyunc";
	}
	bool OsnovaOdDrveta() const
	{
		return true;
	}
};

class DuvackiInstrument: public Instrument
{
public:
	DuvackiInstrument()
	{
		cout << "DuvackiInstrument() ";
	}
	~DuvackiInstrument()
	{
		cout << " ~DuvackiInstrument()";
	}
	char* TipInstrumenta() const
	{
		return "duvacki instrument";
	}

	bool ImaDugmice() const
	{
		return true;
	}
};

class Truba: public DuvackiInstrument
{
public:
	Truba()
	{
		cout << "Truba()" << endl;
	}
	~Truba()
	{
		cout << " ~Truba()";
	}
	char* ImeInstrumenta() const
	{
		return "Truba";
	}
	char* Sviraj() const
	{
		return "Truba: tuturutu";
	}

	char* NastimujSe() const
	{
		return "Truba: trrrr";
	}
	bool OsnovaOdMetala() const
	{
		return true;
	}
};

class Tuba: public DuvackiInstrument
{
public:
	Tuba()
	{
		cout << "Tuba()" << endl;
	}
	~Tuba()
	{
		cout << " ~Tuba()";
	}
	char* ImeInstrumenta() const
	{
		return "Tuba";
	}

	char* NastimujSe() const
	{
		return "Tuba: TRRRRRR";
	}

	char* Sviraj() const
	{
		return "Tuba: TUTURUTU";
	}
	bool OsnovaOdMetala() const
	{
		return true;
	}
};

class Trombon: public DuvackiInstrument
{
public:
	Trombon()
	{
		cout << "Trombon()" << endl;
	}
	~Trombon()
	{
		cout << " ~Trombon()";
	}
	char* ImeInstrumenta() const
	{
		return "Trombon";
	}
	char* Sviraj() const
	{
		return "Trombon: tUtUrUtU";
	}

	char* NastimujSe() const
	{
		return "Trombon: TRBBBBB";
	}

	bool OsnovaOdMetala() const
	{
		return true;
	}
};

class Horna: public DuvackiInstrument
{
public:
	Horna()
	{
		cout << "Horna()" << endl;
	}
	~Horna()
	{
		cout << " ~Horna()";
	}
	char* ImeInstrumenta() const
	{
		return "Horna";
	}
	char* Sviraj() const
	{
		return "Horna: TuTuRuTu";
	}
	bool OsnovaOdMetala() const
	{
		return true;
	}
	
	char* NastimujSe() const
	{
		return "Horna: HRRRRR";
	}
};

class Saksofon: public DuvackiInstrument
{
public:
	Saksofon()
	{
		cout << "Saksofon()" << endl;
	}
	~Saksofon()
	{
		cout << " ~Saksofon()";
	}
	char* ImeInstrumenta() const
	{
		return "Saksofon";
	}
	char* Sviraj() const
	{
		return "Saksofon: fuuu";
	}

	char* NastimujSe() const
	{
		return "Saksofon: Skeek";
	}

	bool OsnovaOdMetala() const
	{
		return true;
	}
};

class Flauta: public DuvackiInstrument
{
public:
	Flauta()
	{
		cout << "Flauta()" << endl;
	}
	~Flauta()
	{
		cout << " ~Flauta()";
	}
	char* ImeInstrumenta() const
	{
		return  "Flauta";
	}
	char* Sviraj() const
	{
		return "Flauta: fiii";
	}

	char* NastimujSe() const
	{
		return "Flauta: Fluflu";
	}

	bool OsnovaOdMetala() const
	{
		return true;
	}
};

class UdarackiInstrument: public Instrument
{
public:
	UdarackiInstrument()
	{
		cout << "UdarackiInstrument() ";
	}
	~UdarackiInstrument()
	{
		cout << " ~UdarackiInstrument()";
	}
	char* TipInstrumenta() const
	{
		return "udaracki instrument";
	}
	char* NastimujSe() const
	{
		return "Udaracki instrument ne mora da se stimuje.";
	}
	bool ImaUdaraljke() const
	{
		return true;
	}
};

class Bubanj: public UdarackiInstrument
{
public:
	Bubanj()
	{
		cout << "Bubanj()" << endl;
	}
	~Bubanj()
	{
		cout << " ~Bubanj()";
	}
	char* ImeInstrumenta() const
	{
		return "Bubanj";
	}
	char* Sviraj() const
	{
		return "Bubanj: tam - tam";
	}
	bool OsnovaOdDrveta() const
	{
		return true;
	}
};

class Ksilofon: public UdarackiInstrument
{
public:
	Ksilofon()
	{
		cout << "Ksilofon()" << endl;
	}
	~Ksilofon()
	{
		cout << " ~Ksilofon()";
	}
	char* ImeInstrumenta() const
	{
		return "Ksilofon";
	}
	char* Sviraj() const
	{
		return "Ksilofon: ksi - ksi";
	}
	bool OsnovaOdMetala() const
	{
		return true;
	}
};

class Timpani: public UdarackiInstrument
{
public:
	Timpani()
	{
		cout << "Timpani()" << endl;
	}
	~Timpani()
	{
		cout << " ~Timpani()";
	}
	char* ImeInstrumenta() const
	{
		return "Timpani";
	}
	char* Sviraj() const
	{
		return "Timpani: tam - taram";
	}
	bool OsnovaOdDrveta() const
	{
		return true;
	}
};

void Osobine(const Instrument &i, ostream& ostr)
{
	i.Ispisi(ostr);
}

int main()
{
	Instrument* Orkestar[15];
	int i = 0;

	cout << endl<<"Orkestar dolazi na scenu: "<<endl<<endl;

	Orkestar[i++] = new Violina;
	Orkestar[i++] = new Viola;
	Orkestar[i++] = new Violoncelo;
	Orkestar[i++] = new Kontrabas;
	Orkestar[i++] = new Harfa;
	Orkestar[i++] = new Gitara;
	Orkestar[i++] = new Truba;
	Orkestar[i++] = new Tuba;
	Orkestar[i++] = new Trombon;
	Orkestar[i++] = new Horna;
	Orkestar[i++] = new Saksofon;
	Orkestar[i++] = new Flauta;
	Orkestar[i++] = new Bubanj;
	Orkestar[i++] = new Ksilofon;
	Orkestar[i++] = new Timpani;

	for (i = 0; i < 15; i++)
		Orkestar[i]->Ispisi(cout);
	/*
	for (i = 0; i < 15; i++)
		Osobine(*Orkestar[i]);*/
	cout << endl<<endl<<"Stimujemo orkestar:" << endl;

	for (i = 0; i < 15; i++)
		cout << Orkestar[i]->NastimujSe() << endl;

	cout << endl << "Orkestar uspesno nastimovan!" << endl;
	cout << endl << "Orkestar sada moze da svira:" << endl<<endl;

	for (i = 0; i < 15; i++)
		cout << Orkestar[i]->Sviraj() <<endl;
	
	for (i = 1; i < 15; i+=2)
		cout << "Sada " << Orkestar[i]->ImeInstrumenta() 
				<< " ima solo " << endl <<"\t"<< Orkestar[i]->Sviraj() << endl;

	for (i = 0; i < 15; i+=2)
		cout << Orkestar[i]->Sviraj() <<endl;

	cout <<endl<< "Orkestar svira na bis!" << endl<<endl;

	for (i = 14; i >= 0; i-=2)
		cout << Orkestar[i]->Sviraj() <<endl;


	cout << endl<< endl<< "Koncert zavrsen, orkestar ide kuci!" << endl<<endl;
	for (i = 0; i < 15; i++)
		delete Orkestar[i];
	return 0;
}


/* Izlaz iz programa:

Orkestar dolazi na scenu:

Instrument() 1 ZicaniInstrument() Violina()
Instrument() 2 ZicaniInstrument() Viola()
Instrument() 3 ZicaniInstrument() Violoncelo()
Instrument() 4 ZicaniInstrument() Kontrabas()
Instrument() 5 ZicaniInstrument() Harfa()
Instrument() 6 ZicaniInstrument() Gitara()
Instrument() 7 DuvackiInstrument() Truba()
Instrument() 8 DuvackiInstrument() Tuba()
Instrument() 9 DuvackiInstrument() Trombon()
Instrument() 10 DuvackiInstrument() Horna()
Instrument() 11 DuvackiInstrument() Saksofon()
Instrument() 12 DuvackiInstrument() Flauta()
Instrument() 13 UdarackiInstrument() Bubanj()
Instrument() 14 UdarackiInstrument() Ksilofon()
Instrument() 15 UdarackiInstrument() Timpani()


Violina je zicani instrument
        ima zice,
        nema dugmice,
        nema udaraljke,
        nema osnovu od metala,
        nema osnovu od plastike,
        ima osnovu od drveta.


Viola je zicani instrument
        ima zice,
        nema dugmice,
        nema udaraljke,
        nema osnovu od metala,
        nema osnovu od plastike,
        ima osnovu od drveta.


Violoncelo je zicani instrument
        ima zice,
        nema dugmice,
        nema udaraljke,
        nema osnovu od metala,
        nema osnovu od plastike,
        ima osnovu od drveta.


Kontrabas je zicani instrument
        ima zice,
        nema dugmice,
        nema udaraljke,
        nema osnovu od metala,
        nema osnovu od plastike,
        ima osnovu od drveta.


Harfa je zicani instrument
        ima zice,
        nema dugmice,
        nema udaraljke,
        ima osnovu od metala,
        nema osnovu od plastike,
        nema osnovu od drveta.


Gitara je zicani instrument
        ima zice,
        nema dugmice,
        nema udaraljke,
        nema osnovu od metala,
        nema osnovu od plastike,
        ima osnovu od drveta.


Truba je duvacki instrument
        nema zice,
        ima dugmice,
        nema udaraljke,
        ima osnovu od metala,
        nema osnovu od plastike,
        nema osnovu od drveta.


Tuba je duvacki instrument
        nema zice,
        ima dugmice,
        nema udaraljke,
        ima osnovu od metala,
        nema osnovu od plastike,
        nema osnovu od drveta.


Trombon je duvacki instrument
        nema zice,
        ima dugmice,
        nema udaraljke,
        ima osnovu od metala,
        nema osnovu od plastike,
        nema osnovu od drveta.


Horna je duvacki instrument
        nema zice,
        ima dugmice,
        nema udaraljke,
        ima osnovu od metala,
        nema osnovu od plastike,
        nema osnovu od drveta.


Saksofon je duvacki instrument
        nema zice,
        ima dugmice,
        nema udaraljke,
        ima osnovu od metala,
        nema osnovu od plastike,
        nema osnovu od drveta.


Flauta je duvacki instrument
        nema zice,
        ima dugmice,
        nema udaraljke,
        ima osnovu od metala,
        nema osnovu od plastike,
        nema osnovu od drveta.


Bubanj je udaracki instrument
        nema zice,
        nema dugmice,
        ima udaraljke,
        nema osnovu od metala,
        nema osnovu od plastike,
        ima osnovu od drveta.


Ksilofon je udaracki instrument
        nema zice,
        nema dugmice,
        ima udaraljke,
        ima osnovu od metala,
        nema osnovu od plastike,
        nema osnovu od drveta.


Timpani je udaracki instrument
        nema zice,
        nema dugmice,
        ima udaraljke,
        nema osnovu od metala,
        nema osnovu od plastike,
        ima osnovu od drveta.


Stimujemo orkestar:
Violina: shkriiiiiiip, shkriiiiip
Viola: shkriiiiiiip, shkriiiiip
Violoncelo: shkriiiiiiip, shkriiiiip
Kontrabas: SHKRIIIIP, SHKRIIIP
Harfa: zdhfguyunc
Gitara: zdhfguyunc
Truba: trrrr
Tuba: TRRRRRR
Trombon: TRBBBBB
Horna: HRRRRR
Saksofon: Skeek
Flauta: Fluflu
Udaracki instrument ne mora da se stimuje.
Udaracki instrument ne mora da se stimuje.
Udaracki instrument ne mora da se stimuje.

Orkestar uspesno nastimovan!

Orkestar sada moze da svira:

Violina: cigu - ligu
Viola: CIGU - LIGU
Violoncelo: CIGU - ligu
Kontrabas: CIIIIIGUUUU - LIIIIGUUUU
Harfa: zdronc
Gitara: tra-la-la
Truba: tuturutu
Tuba: TUTURUTU
Trombon: tUtUrUtU
Horna: TuTuRuTu
Saksofon: fuuu
Flauta: fiii
Bubanj: tam - tam
Ksilofon: ksi - ksi
Timpani: tam - taram
Sada Viola ima solo
        Viola: CIGU - LIGU
Sada Kontrabas ima solo
        Kontrabas: CIIIIIGUUUU - LIIIIGUUUU
Sada Gitara ima solo
        Gitara: tra-la-la
Sada Tuba ima solo
        Tuba: TUTURUTU
Sada Horna ima solo
        Horna: TuTuRuTu
Sada Flauta ima solo
        Flauta: fiii
Sada Ksilofon ima solo
        Ksilofon: ksi - ksi
Violina: cigu - ligu
Violoncelo: CIGU - ligu
Harfa: zdronc
Truba: tuturutu
Trombon: tUtUrUtU
Saksofon: fuuu
Bubanj: tam - tam
Timpani: tam - taram

Orkestar svira na bis!

Timpani: tam - taram
Bubanj: tam - tam
Saksofon: fuuu
Trombon: tUtUrUtU
Truba: tuturutu
Harfa: zdronc
Violoncelo: CIGU - ligu
Violina: cigu - ligu


Koncert zavrsen, orkestar ide kuci!

 ~Violina() ~ZicaniInstrument() ~Instrument() 14
 ~Viola() ~ZicaniInstrument() ~Instrument() 13
 ~Violoncelo() ~ZicaniInstrument() ~Instrument() 12
 ~Kontrabas() ~ZicaniInstrument() ~Instrument() 11
 ~Harfa() ~ZicaniInstrument() ~Instrument() 10
 ~Gitara() ~ZicaniInstrument() ~Instrument() 9
 ~Truba() ~DuvackiInstrument() ~Instrument() 8
 ~Tuba() ~DuvackiInstrument() ~Instrument() 7
 ~Trombon() ~DuvackiInstrument() ~Instrument() 6
 ~Horna() ~DuvackiInstrument() ~Instrument() 5
 ~Saksofon() ~DuvackiInstrument() ~Instrument() 4
 ~Flauta() ~DuvackiInstrument() ~Instrument() 3
 ~Bubanj() ~UdarackiInstrument() ~Instrument() 2
 ~Ksilofon() ~UdarackiInstrument() ~Instrument() 1
 ~Timpani() ~UdarackiInstrument() ~Instrument() 0
*/