#include <iostream>
#include <vector>

using namespace std;

class Duz 
{
public:
	Duz( int X0, int Y0, int X1, int Y1, int Boja )
		: x0(X0), y0(Y0), x1(X1), y1(Y1), boja(Boja)
		{}

	int x0, y0, x1, y1;
	int boja;
};

ostream& operator<< ( ostream& ostr, const Duz& d )
{
	ostr << "{ " 
		 << d.x0 << ", "
		 << d.y0 << ", "
		 << d.x1 << ", "
		 << d.y1 << ", "
		 << d.boja << " }";
	return ostr;
}

class Lik
{
public:
	Lik( int boja )
		: _boja(boja)
		{}

	virtual ~Lik()
		{}
		
	virtual int PrevodjenjePlus( vector<Duz>& duzi, double eps ) = 0;	

	int Prevodjenje( vector<Duz>& duzi, double eps )
		{
		duzi.clear();
		return PrevodjenjePlus( duzi, eps );
		}
		
protected:
	int _boja;
};

class Pravougaonik : public Lik
{
public:
	Pravougaonik( int x0, int y0, int a, int b, int boja )
		: Lik(boja),
		  _x0(x0), _y0(y0), _a(a), _b(b)
		{}
		
	int PrevodjenjePlus( vector<Duz>& duzi, double )
		{
		// u narednim redovima se koristi ekvivalent 
		// sledeceg para naredbi
		//Duz d( _x0, _y0, _x0+_a, _y0, boja );
		//duzi.push_back( d );
		duzi.push_back( Duz( _x0, _y0, _x0+_a, _y0, _boja ));
		duzi.push_back( Duz( _x0+_a, _y0, _x0+_a, _y0+_b, _boja ));
		duzi.push_back( Duz( _x0+_a, _y0+_b, _x0, _y0+_b, _boja ));
		duzi.push_back( Duz( _x0, _y0+_b, _x0, _y0, _boja ));
		return 4;
		}
	
private:
	int _x0, _y0, _a, _b;
};

class Kvadrat : public Pravougaonik
{
public:
	Kvadrat( int x0, int y0, int a, int boja )
		: Pravougaonik( x0, y0, a, a, boja )
		{}
};

main()
{
	vector<Duz> duzi;

	Pravougaonik p( 0,0,10,5,1);
	p.PrevodjenjePlus( duzi, 0 );

	Kvadrat k( 20, 10, 40, 7 );
	k.PrevodjenjePlus( duzi, 0 );
	
	cout << "Duzi:" << endl;
	for( unsigned i=0; i<duzi.size(); i++ )
		cout << duzi[i] << endl;
		
	return 0;
}
