
class VPB 
{

public:
	VPB():_cifre() //poziva se konstruktor bez argumenata za Niz _cifre
	{}

	//konstruktor koji broj x smesta u niz
	VPB(unsigned x) 
	{
	for(unsigned i=0;x>0;i++)
		{
		_cifre[i] = x % 10;
		x = x / 10;
		}
	}

	unsigned BrojCifara() const 
	{
	return _cifre.Duzina();
	}

	//nije const jer pristupanje elemntu niza moze promeniti niz!
	int& operator [] (unsigned i) 	
	{
	return _cifre[i];
	}

	//Mogli smo Pisi i Citaj da definisemo kao private
	//ali onda operatore << i >> kao friend!!!

	void Pisi( ostream& ostr ) 
	{
	unsigned bc = BrojCifara();
	if (bc)
		for(int i=bc-1;i>=0;i--)
			ostr << _cifre[i];
	else ostr << 0;
	}

	void Citaj (istream& istr) 
	{
	istr >> ws; //preskace prazna mesta
	unsigned i = 0;
	int c = istr.get();
	while ( istr && c>='0' && c<='9')
		{
		_cifre[i++] = c - '0';
		c = istr.get();
		}
	istr.putback(c); //ucitali smo jedan znak vise (blanko) pa ga ovime vracamo

	//da budu cifre poredjane u obrnutom redosledu
	for(unsigned j=0;j<i; ) //cifre u nizu su u obrn. redosl.
		{
		int tmp = _cifre[--i];
		_cifre[i] = _cifre[j];
		_cifre[j++] = tmp;
		}
	}
	
	//Operator + poziva operator +=, malo neprirodno
	//resenje ali moze i tako (ne preporucujem ovo)
	VPB operator + ( VPB& b) 
	{
	VPB r(*this);
	r+=b;
	return r;
	}

	VPB& operator = ( const VPB& b) 
	{
	//koristimo op. dodele za objekte klase Niz
	_cifre = b._cifre;
	return *this;
	}

	//nije const jer b[i] moze da promeni objekat (din. nizovi)!!!
	VPB& operator += ( VPB& b)
	{
	unsigned prenos = 0;
	unsigned i;
	unsigned bc = b.BrojCifara();
	for(i=0;i<bc;i++)
		if((_cifre[i]+= b[i]+prenos)>9)
		{
		prenos = _cifre[i]/10;
		_cifre[i]%=10;
		}
		else prenos = 0;	
	for( ;prenos>0;i++)
		{
		prenos+= _cifre[i];
		_cifre[i] = prenos % 10;
		prenos = _cifre[i] / 10;
		}

	return *this;
	}

	//Implementirati operatror-
	//Implementirati operator *

	bool operator == ( VPB& b)
	{
	return !Poredjenje(b);
	}

	bool operator > (VPB& b)
	{
	return (Poredjenje(b)>0);
	}

	/* Imlementirati operatore 
	<, <=, >=, !=
	*/
private:
	Niz _cifre;

	//vraca negativan br. ako je prvi arg. manji od drugog
	//Br. npr. 1245 je u nizu smesten kao 5,4,2,1
	int Poredjenje( VPB& b)
	{
	int i = BrojCifara() - b.BrojCifara();
	if(i) return i;
	for(unsigned j=BrojCifara()-1;j>0;j--)
		{
		i = _cifre[j] - b._cifre[j];
		if(i) return i;
		}
	return _cifre[0] - b._cifre[0];
	}

};


ostream& operator <<( ostream& ostr,VPB& n) {
n.Pisi(ostr);
return ostr;
}


istream& operator >> (istream& istr,VPB& n) {
n.Citaj(istr);
return istr;
}



/*Poto nije implementirano mnoenje, funkcija fakt je pod komentarima
VPB fakt(unsigned n) 
{ 
    VPB r(1); 
    for(unsigned i=n;i>=2;i--)
        r = r * i;
    return r; 
}
*/

main() {

/*
VPB zbir(0);
for(unsigned i=1;i<=100;i++)
    zbir += fakt(i);
cout << "Zbir je:" << zbir;
*/

VPB v;
VPB c;
cout << "Unesi dva prirodna broja v i c:" << endl;
cin >> v >> c;
if (v==c) cout << "v i c su jednaki brojevi!" << endl;
    else 
    {
    cout << "v i c su razliciti brojevi!" << endl;
    if(v>c) cout << "Pri tom je v vece od c." << endl;
    else cout << "Pri tom je v manje od c." << endl;
    }

return 0;
}

