
// Resenje kolege Marka Manojlovica

/* Klasa datum;
	1) konstruktor sa podrazumevanim vrednostima;
	2) operatori <<, >>, ++, --;
	3) metode VratiMesec, VratiDan i VratiGod. */

#include <iostream>

using namespace std;

class Datum
{
public:
	Datum(int d = 1, int m = 1, int g = 2005): _Dan(d), _Mesec(m), _Godina(g)
	{
	}
	ostream& Pisi(ostream &str) const
	{
		return str << _Dan << '.' << _Mesec << '.' << _Godina << '.';
	}
	istream& Citaj(istream &str)
	{
		char c;
		return str >> _Dan >> c >> _Mesec >> c >> _Godina >> c;
	}
	Datum& operator ++()
	{
		_SledeciDan();
		return *this;
	}
	Datum operator ++(int)
	{
		Datum y = *this;
		_SledeciDan();
		return y;
	}
	int VratiDan() const
	{
		return _Dan;
	}
	int VratiMesec() const
	{
		return _Mesec;
	}
	int VratiGodinu() const
	{
		return _Godina;
	}
private:
	int _Prestupna()
	{
		return !(_Godina % 4) && (_Godina % 100 || !(_Godina % 400));
	}
	int _BrojDana()
	{
		switch (_Mesec)
		{
			case 4: case 6: case 9: case 11:
				return 30;
			case 2:
				if (_Prestupna())
					return 29;
				else
					return 28;
			default:
				return 31;
		}
	}
	void _SledeciDan()
	{
		if (++_Dan > _BrojDana())
		{
			_Dan = 1;
			if (++_Mesec > 12)
			{
				_Mesec = 1;
				_Godina++;
			}
		}
	}
	int _Dan, _Mesec, _Godina;
};

ostream& operator << (ostream &str, const Datum &x)
{
	return x.Pisi(str);
}

istream& operator >> (istream &str, Datum &x)
{
	return x.Citaj(str);
}


int main()
{
	Datum datum;
	cin >> datum;
	cout << "Postfiksno ++" << endl;
	cout << datum++ << endl;
	cout << datum << endl;
	cout << "Prefiksno ++" << endl;
	cout << ++datum << endl;
	cout << datum << endl;
	return 0;
}
