
// Resenje kolege Mirka Spasica

#include <iostream>
using namespace std;

class Datum
{
 public:
        //-------------------------------------
        //Konstruktor sa listom inicijalizacije
        //-------------------------------------
        Datum (int d=1,int m=1,int g=2005)
        :_dan(d),_mesec(m),_godina(g)
        {}

        //-------------------------------------
        //Metodi za pristupanje elementima
        //-------------------------------------
        int Dan() const
        {
            return _dan;
        }
        int Mesec() const
        {
            return _mesec;
        }
        int Godina() const
        {
            return _godina;
        }

        //-------------------------------------
        //Metod za postavljanje datuma
        //-------------------------------------
        void PostaviDatum(int d,int m,int g)
        {
             _dan=d;
             _mesec=m;
             _godina=g;
        }

        //---------------------------------------
        //Medode za pisanje i citanje
        //---------------------------------------
        ostream& Pisi(ostream& str) const
        {
          return str <<_dan<<'.'<<_mesec<<'.'<<_godina<<'.'<<endl;
        }

        istream& Citaj(istream& str)
        {
        char c,d,e;
        str >> _dan >> c >> _mesec >> d >> _godina >> e;
        if (c!=d || c!=e || c!='.')
                 str.setstate(ios::failbit);
        if (_mesec>12 || _mesec<1)
                 str.setstate(ios::failbit);
        if (_dan>Broj_dana() || _dan<1)
                 str.setstate(ios::failbit);
        return str;
        }

        //----------------------------------------
        //Aritmeticke operacije sa celim brojem
        //----------------------------------------
        Datum operator + (const int& x) const
        {
              int i;
              Datum r=*this;
              for(i=0;i<x;i++)
                   ++r;
              return r;
        }
        Datum operator - (const int& x) const
        {
              int i;
              Datum r=*this;
              for(i=0;i<x;i++)
                   --r;
              return r;
        }
        //----------------------------------------
        //Operacije poredjenja
        //----------------------------------------
        bool operator == (const Datum& x) const
        {
        return ((_dan==x.Dan()) && (_mesec==x.Mesec()) && (_godina==x.Godina()));
        }
        bool operator != (const Datum& x) const
        {
             return !((*this)==x);
        }
        bool operator <= (const Datum& x) const
        {
             if (_godina < x.Godina()) return true;
             if (_godina > x.Godina()) return false;
             if (_mesec < x.Mesec()) return true;
             if (_mesec > x.Mesec()) return false;
             if (_dan <= x.Dan()) return true;
             return false;
        }
        bool operator < (const Datum& x) const
        {
             return ((*this)<=x && (*this)!=x);
        }
        bool operator > (const Datum& x) const
        {
             return !((*this)<=x);
        }
        bool operator >= (const Datum& x) const
        {
             return !((*this)<x);
        }

        //------------------------------------------
        //Operatori inkrementiranja i dekrementiranja
        //------------------------------------------
        //prefiksno ++
        Datum& operator ++()
        {
               if (_dan!=Broj_dana()) _dan++;
               else
               {
                   if (_mesec==12) {_dan=_mesec=1;_godina++;}
                   else {_dan=1;_mesec++;}
               }
               return *this;
        }
        //postfiksno ++
        Datum operator ++(int)
        {
              Datum sutra=*this;
              if (_dan!=Broj_dana()) _dan++;
              else
              {
                  if (_mesec==12) {_dan=_mesec=1;_godina++;}
                  else {_dan=1;_mesec++;}
              }
              return sutra;
        }
        //prefiksno --
        Datum& operator --()
        {
               if (_dan!=1) _dan--;
               else
               {
                   if (_mesec==1) {_dan=31;_mesec=12;_godina--;}
                   else {_mesec--;_dan=Broj_dana();}
               }
               return *this;
        }
        //postfiksno --
        Datum operator --(int)
        {
              Datum juce=*this;
              if (_dan!=1) _dan--;
              else
              {
                  if (_mesec==1) {_dan=31;_mesec=12;_godina--;}
                  else {_mesec--;_dan=Broj_dana();}
              }
              return juce;
        }
        //-----------------------------------------
        //Binarna aritmeticka operacija
        //racuna broj dana izmedju dva datuma
        //-----------------------------------------
        int operator - (const Datum& d) const
        {
            Datum t,x=*this,y=d;
            int i, state(1);
            if (x < y)
            {
               t=x;
			   x=y;
			   y=t;
			   state=-1;
            }
            for (i=0,t=y;t!=x;t++,i++)
                ;
            return i*state;
        }
 private:
        //-------------------------------------
        //Medod koji racuna broj dana u mesecu
        //za odgovarajuci datum
        //-------------------------------------
        int Broj_dana() const
        {
            switch((*this).Mesec())
            {
             case 1:
             case 3:
             case 5:
             case 7:
             case 8:
             case 10:
             case 12: return 31;
             case 2: return Prestupna()?29:28;
             case 4:
             case 6:
             case 9:
             case 11: return 30;
             default: return 0;
            }
        }
        //--------------------------------------
        //Medod za izracunavanje prestupne godine
        //--------------------------------------
        int Prestupna() const
        {
         return ((_godina%4==0 && _godina%100) || (_godina%400==0));
        }


         //----------------------------------------
         //Clanovi podaci
         //----------------------------------------
         int _dan;
         int _mesec;
         int _godina;
};
//-------------------------------------------------
//Operatori za pisanje i citanje datuma
//-------------------------------------------------
ostream& operator << (ostream& str,const Datum& d)
{
         return d.Pisi(str);
}

istream& operator >> (istream& str, Datum& d)
{
         return d.Citaj(str);
}
//----------------------------------------------------------
//Glavna funkcija programa demonstrira upotrebu klase Datum
//----------------------------------------------------------
main()
{
      Datum d,d1,d2;
      cout << "Unesi danasnji datum" << endl;
      cin >> d;
      d1 = d+1;
      cout << "Danas je " << d;
      cout << "Sutra je " << d1;
      cout << "Za 10 dana je " << d+10;
      cout << "Unesi datum ispita iz ORS-a " << endl;
      cin >> d2;
      cout << "Imas jos "<< d2-d << ((d2-d>1 || d2-d<-1)?" dana.":"dan.")<< endl;
      return 0;
}