# -*- coding: utf-8 -*-
"""Untitled5.ipynb

Automatically generated by Colab.
"""

!pip install pyngrok

from flask import Flask, jsonify, request, render_template_string
from pyngrok import ngrok
import json

app = Flask(__name__)

"""Ucitati listu filmova iz datoteke filmovi.json. Film se sastoji iz naziva, reditelja, godine, zanrovi, vreme (zadato u obliku HH:MM)"""

filmovi = []
with open('filmovi.json', 'r') as fajl:
  filmovi = json.load(fajl)

"""Napisati HTML nisku koja ce na pocetnoj stranici dodati navigaciju ka stranicama /projekcije, /projekcije-filter, /projekcije-zanr

"""

POCETNA = """
<h1> Navigacija </h1>
<ul>
<li><a href="/projekcije"> Projekcije </a></li>
<li><a href="/projekcije-filter"> Projekcije filter </a></li>
<li><a href="/projekcije-zanr"> Projekcije po zanru </a></li>
</ul>
"""

@app.route('/')
def pocetna():
  return render_template_string(POCETNA)

"""Napisati HTML nisku koja ce na stranici /projekcije izlistati sve projekcije koje su u listu.

Takodje dodati i formular putem kojeg je moguce dodati film u listu filmova. Formular ce podatke slati funkciji koja se nalazi na putanji /dodaj-film.
"""

PROJEKCIJE = """
<ul>
{% for p in projekcije %}
<li> {{p.naziv}} | {{ p.reditelj }} | {{ p.vreme }} | {{ p.zanrovi }}
{% endfor %}
</ul>
<form action='/dodaj-film' method='POST'>
Naziv: <br>
<input type='text' name='naziv'>
Reditelj: <br>
<input type='text' name='reditelj'>
Godina: <br>
<input type='text' name='godina'>
Zanrovi razdvojeni razmakom: <br>
<input type='text' name='zanrovi'>
<input type='submit' value='Dodaj'>
</form>
<a href="/">POCETNA</a>
"""

@app.route('/projekcije')
def projekcije():
  return render_template_string(PROJEKCIJE, projekcije = filmovi)

@app.route('/dodaj-film', methods=['POST'])
def dodavanje():
  naziv = request.form.get('naziv')
  reditelj = request.form.get('reditelj')
  godina = request.form.get('godina')
  zanrovi = request.form.get('zanrovi')
  zanrovi = zanrovi.split(' ')
  filmovi.append({
      'naziv': naziv,
      'reditelj': reditelj,
      'godina': int(godina),
      'zanrovi': zanrovi,
  })
  return projekcije()

"""Napisati HTML nisku koja ce na stranici /projekcije-filter izlistati sve projekcije koje se prikazuju nakon navedenog vremena projekcije"""

FILTER = """
<form method='GET'>

<input type='radio' name='termin' value='17:00'> 17h <br>
<input type='radio' name='termin' value='13:00'> 13h <br>
<input type='radio' name='termin' value='11:00'> 11h <br>
<input type='submit' value='Filter'>
</form>

<ul>
{% for p in projekcije %}
<li> {{p.naziv}} | {{ p.reditelj }} | {{ p.vreme }} | {{ p.zanrovi }}
{% endfor %}
</ul>
<a href="/"> POCETNA </a>
"""

@app.route('/projekcije-filter', method=['GET'])
def filtriranje():
  vreme = request.args.get('termin')
  za_ispis = []
  for f in filmovi:
    if vreme == None or f['vreme'] > vreme:
      za_ispis.append(f)

  return render_template_string(FILTER, projekcije = za_ispis)

"""Napisati HTML nisku koja ce izlistati sve projekcije koje odgovaraju prosledjenom zanru"""

ZANROVI = """
<form method='GET'>

Zanr: <input type='text' name='zanr'> <br>
<input type='submit' value='Pretrazi'>
</form>

<ul>
{% for p in projekcije %}
<li> {{p.naziv}} | {{ p.reditelj }} | {{ p.vreme }} | {{ p.zanrovi }}
{% endfor %}
</ul>
<a href="/"> POCETNA </a>
"""

@app.route('/projekcije-zanr', method=['GET'])
def zanrovi():
  zanr = request.args.get('zanr')
  za_ispis = []
  for f in filmovi:
    if zanr == None or zanr in f['zanrovi']:
      za_ispis.append(f)

  return render_template_string(ZANROVI, projekcije = za_ispis)


app.run(port=5000)
