# -*- coding: utf-8 -*-
"""MNRA4.ipynb

Automatically generated by Colab.

"""

!pip install pyngrok

from flask import Flask, jsonify, request, render_template_string
app = Flask(__name__)

"""Primer upisivanja podataka u json fajl."""

import json
ucenici = [
      { "id": 1, "ime": "Ana", "razred": 2, "ocene": [5, 4, 5] },
      { "id": 2, "ime": "Marko", "razred": 3, "ocene": [3, 4, 4] },
      { "id": 3, "ime": "Ivana", "razred": 2, "ocene": [5, 5, 5] }
      ]
with open('ucenici.json', "w") as fajl:
  json.dump(ucenici, fajl)

"""Primer učivanja podataka iz json fajla. Kako bi se otvaranje uspešno izvršilo, potrebno je da fajl postoji."""

students = []
with open('ucenici.json', 'r') as fajl:
 students = json.load(fajl)
students

"""Napisati funkciju koja vraća prosečnu ocenu iz niza ocena, ukoliko je taj iz prazan vratiti 0"""

def prosek1(ocene):
  return sum(ocene)/len(ocene) if ocene!=[] else 0

"""Napisati HTML nisku koja će sadržati naslov i listu koja sadrži linkove ka stranicama: /ucenici-spisak, /ucenici-prosek, /ucenici-imena"""

POCETNA = """
<h1 style='color: blue'> Navigacija </h1>
<ul>
<li><a href='/ucenici-spisak'> Spisak ucenika i dodanje </a></li>
<li><a href='/ucenici-prosek'> Spisak ucenika po proseku </a></li>
<li><a href='/ucenici-imena'> Spisak ucenika po imenu </a></li>
</ul>
"""

"""Napisati funkciju koja će prikazati početnu stranicu"""

@app.route('/')
def pocetna():
  return render_template_string(POCETNA)

"""Napisati HTML nisku koja će sadržati naslov i listu učenika. Svaka stavka liste sadrži ime, razred i ocene učenika.

Napraviti formular koji će POST metodom dodati novog učenika u niz učenika. Potrebno je uneti ime, razred i niz ocena razdvojene zarezom. Takođe dodati link ka početnoj stranici.
"""

SPISAK_HTML = """
<h1> Spisak ucenika </h1>
<ul>
  {% for u in ucenici %}
    <li> {{ u.ime }} | {{ u.razred }} | {{ u.ocene }}</li>
  {% endfor %}
</ul>

<h2>Upisi ucenika</h2>
<form action='/dodavanje' method='POST'>
Ime: <input type='text' name='ime'> <br>
Razred: <input type='text' name='razred'>
Ocene (razdvojene zarezom): <input type='text' name='ocene'> <br><br>
<input type='submit' value='Posalji podatke'>
</form>
<a href='/'> POCETNA </a>
"""

"""Napisati funkciju koja će prikazati spisak učenika uz odgovarajuću stranicu."""

@app.route('/ucenici-spisak', methods=['GET'])
def spisak():
  return render_template_string(SPISAK_HTML, ucenici=students)

"""Napisati funkciju koja će se izvršiti prilikom dodavanja studenta (koristeći formular iz prethodnog zadatka). Nakon dodavanja prikazati ažuriran spisak učenika."""

@app.route('/dodavanje', methods=['POST'])
def dodavanjeUcenika():
  ime = request.form.get('ime')
  razred = int(request.form.get('razred'))
  ocene = request.form.get('ocene')
  ocene_br = []
  ocene = ocene.split(',')
  for o in ocene:
    ocene_br.append(int(o))
  students.append({
      'id': len(students)+1,
      'ime': ime,
      'razred': razred,
      'ocene': ocene_br
  })
  return spisak()

"""Napisati HTML nisku koja će prikazati listu učenika (prikazati ime, razred i prosek svakog učenika).

Dodati formular koji će GET metodom prikazivati učenike sa prosekom većim ili jednakim prosleđenom. Ukoliko prosečna ocena nije uneta putem formulara, prikazati sve učenike.
"""

PROSEK_HTML="""
<h1> Pretraga ucenika po proseku </h1>
  <form method = 'GET'>
  Prosecna ocena za pretragu: <input type='number' step='0.1' name='prosek'> <br>
  <input type='submit' value='Pretrazi'>
  </form>
<h2> Spisak ucenika po proseku </h2>
<ul>
  {% for u in ucenici %}
    <li>{{ u.ime }} | {{ u.razred }} | {{ u.prosek }}</li>
  {% endfor %}
</ul>
<a href='/'> POCETNA </a>

"""

"""Napisati funkciju koja prikazuje učenike po proseku. Potrebno je transformisati postojeću strukturu učenika i dodati prosek."""

@app.route('/ucenici-prosek', methods=['GET'])
def pretragaPoProseku():
  prosek = request.args.get('prosek') #ukoliko nema argumenata vraca None
  ucenici_za_prikaz = []
  for s in students:
    prosek_ucenika = prosek1(s['ocene'])
    if prosek == None or prosek_ucenika >= float(prosek):
      kopija_ucenika = s.copy()
      kopija_ucenika['prosek'] = round(prosek_ucenika,2)
      ucenici_za_prikaz.append(kopija_ucenika)
  return render_template_string(PROSEK_HTML, ucenici = ucenici_za_prikaz)

"""Napisati HTML nisku koja će prikazati listu imena učenika.

"""

IMENA_HTML ="""
<h1> Spisak imena ucenika </h1>
<ul>
  {% for i in imena %}
    <li> {{ i }}</li>
  {% endfor %}
</ul>
<a href='/'> POCETNA </a>

"""

"""Napisati funkciju koja će prikazati HTML stranicu i prikazati imena učenika."""

@app.route('/ucenici-imena', methods = ['GET'])
def imena():
  imena = []
  for s in students:
    imena.append(s['ime'])
  return render_template_string(IMENA_HTML, imena = imena )


app.run(port=5000)

