# -*- coding: utf-8 -*-
"""

Automatically generated by Colab.

Ukoliko se flask koristi iz google colab-a onda je potreno instalirati i pyngrok i postaviti odgovarajuci token za autentikaciju
"""

!pip install pyngrok

from flask import Flask, jsonify, request, render_template_string
app = Flask(__name__)

"""Postaviti na putanji / ispis 'Zdravo svete'

Zatim napisati HTML nisku za pocetnu stranicu sa linkovima ka stranicama /ucenici, /stats, /ucenici-imena
"""

POCETNA = """<h1> LINKOVI KA STRANICAMA </h1>
<ul>
  <li><a href="/ucenici">Svi ucenici</a></li>
  <li><a href="/ucenici/imena">Imena svih ucenika</a></li>
  <li><a href="/ucenici/stats">Statistika</a></li>
</ul>
"""
@app.route("/")
def pocetna():
  return POCETNA#'<h1>Zdravo svete, ovo je nasa prva aplikacija<h1>'

"""Definisati promenljivu ucenici [
    {
        "id": 1,
        "name": "Ana",
        "grade": 2,
        "scores": [5, 4, 5]
    },
    {
        "id": 2,
        "name": "Marko",
        "grade": 3,
        "scores": [3, 4, 4]
    },
    {
        "id": 3,
        "name": "Ivana",
        "grade": 2,
        "scores": [5, 5, 5]
    }
]

Na putanji /ucenici prikazati sve ucenike
"""

ucenici = [ { "id": 1, "ime": "Ana", "razred": 2, "ocene": [5, 4, 5] },
            { "id": 2, "ime": "Marko", "razred": 3, "ocene": [3, 4, 4] },
           { "id": 3, "ime": "Ivana", "razred": 2, "ocene": [5, 5, 5] }
            ]

"""Napisati HTML nisku na kojoj ce biti izlistani svi ucenici"""

UCENICI = """
  <h1> Spisak ucenika </h1>
  <ul>
    {% for u in ucenici %}
      <li> {{ u.ime }} | {{u.razred}}</li>
    {% endfor %}
  </ul>
"""
@app.route('/ucenici')
def vratiUcenike():
  return render_template_string()

"""Na putanji /ucenici/< int:grade > ispisati sve ucenike ciji je razred jednak prosledjenom"""

@app.route('/ucenici/<int:grade>', methods = ['GET'])
def dohvatiRazred(grade):
  istiRazred = []
  for i in ucenici:
    if grade == i['razred']:
      istiRazred.append(i)
  return jsonify(istiRazred)

"""Na putanji /ucenici/min-vrednosti/< float: vrednost> ispisati sve ucenike koji imaju prosecnu ocenu vecu od zadate."""

def prosek(ocene):
  return sum(ocene)/len(ocene)

@app.route("/ucenici/min-vrednosti/<float:vrednost>", methods = ['GET'])
def veciProsek(vrednost):
  za_ispis = []
  for i in ucenici:
    if prosek(i['ocene']) > vrednost:
      za_ispis.append(i)
  return jsonify(za_ispis)

"""Na putanji ucenici/imena/ ispisati imena svih ucenika"""

HTML_IMENA ="""
<h1> IMENA UCENIKA </h1>
<ul>
{% for ime in imena %}
  <li> {{ ime }} </li>
{% endfor %}
</ul>
"""
@app.route('/ucenici/imena')
def dohvatiImena():
  niz_imena = []
  for i in ucenici:
    niz_imena.append(i['ime'])
  return render_template_string(HTML_IMENA, imena=niz_imena)

"""Na putanji ucenici/stats/ ispisati ukupan broj ucenika  i prosecnu ocenu svih ucenika."""

@app.route('/ucenici/stats')
def statistika():
  prosek_svih = 0
  for i in ucenici:
    prosek_svih += prosek(i['ocene'])

  return {
      'ukupan broj': len(ucenici),
      'prosek': prosek_svih/len(ucenici)
  }


app.run(port=5000)

