#! /bin/sh

BIBTEX=bibtex
DVIPS=dvips
LATEX=latex
MAKEINDEX=makeindex
PS2EPSI=ps2epsi
PSNUP=psnup
PSSELECT=psselect
PSTOPS=pstops

TEX_ACO='pr_pok_1 pr_pok_2 pr_pok_3 pr_pok_4 pr_ref_1 pr_ref_2 pr_ref_3 pr_vis_1 pr_vis_2 pr_vis_3 pr_vis_4 pr_pre_1 pr_pre_2'
OTHER_ACO='clean.sh make.sh pr_po_4a.eps pr_po_4b.eps pr_pok_3.eps pr_ref_3.bib pr_vi_2a.tex pr_vi_2b.tex'
TEX_GORAN_PEDJA='pr_uvod pr_form1 pr_pismo pr_form3 pr_form2 pr_font pr_math'

EXAMPLES="$TEX_GORAN_PEDJA $TEX_ACO"

for FILE in $EXAMPLES
do
  $LATEX $FILE

  case $FILE in
      pr_form1|pr_math|pr_pre_2)
          $LATEX $FILE
          ;;
      pr_ref_1|pr_vis_4)
          $MAKEINDEX $FILE.idx
          $LATEX $FILE
          $LATEX $FILE
          ;;
      pr_ref_2)
          $LATEX $FILE
          $LATEX $FILE
          ;;
      pr_ref_3)
          $BIBTEX $FILE
          $LATEX $FILE
          $LATEX $FILE
          ;;
  esac
  
  $DVIPS $FILE.dvi -o $FILE.ps
  $PSNUP -pa4 -1 -d $FILE.ps $FILE.ps_1up
  mv $FILE.ps_1up $FILE.ps

  case $FILE in
      pr_ref_1)
          $PSNUP -pa4 -4 $FILE.ps $FILE.ps_4up
          mv $FILE.ps_4up $FILE.ps
          ;;
      pr_pre_2)
          $PSNUP -pa4 -2 $FILE.ps $FILE.ps_2up
          $PSTOPS "U(21cm,29.7cm)" $FILE.ps_2up $FILE.ps
          rm -f $FILE.ps_2up
          ;;
      pr_vis_4)
          for i in 1 2 3 4 5
          do
            $PSSELECT -p$i $FILE.ps $FILE.$i.ps
          done
          ;;
  esac

  case $FILE in
      pr_vis_4)
          for i in 1 2 3 4 5
          do
            $PS2EPSI $FILE.$i.ps $FILE.$i.epsi
          done
          ;;
      *)
          $PS2EPSI $FILE.ps $FILE.epsi
          ;;
  esac
done
