--connect to stud2020;
drop table dosije;
drop table predmet;
drop table ispitni_rok;
drop table ispit;


drop distinct type prosek;
drop distinct type drzava;
drop distinct type datum;
drop distinct type vreme;
drop distinct type char10;
--commit;


create distinct type 
                prosek as dec(7,2) 
                with comparisons;
create distinct type 
                drzava as varchar(30) 
                with comparisons;


create distinct type char10 as char(10) with comparisons;

create table dosije (
       indeks           integer     not null,  
       korisnik         char10      not null with default user,
       ime              char(10)    not null with default user,
       prezime          varchar(15) not null,
       god_rodjenja     smallint             ,        
       mesto_rodjenja   varchar(20)          ,
       tekuci_prosek    prosek      not null with default prosek(0),
       drzava_rodjenja  drzava               with default 'Srbija',
       primary key      (indeks)             ,
       check  (indeks/10000>=2010)
) in dugacak;

insert into dosije(indeks,ime,prezime,god_rodjenja,mesto_rodjenja) values
(20100021, 'Milos'   , 'Peric'      , 1992, 'Beograd' ),
(20100022, 'Marijana', 'Savkovic'   , 1993, 'Kraljevo'),
(20100023, 'Sanja'   , 'Terzic'     , 1991, 'Beograd' ),
(20100024, 'Nikola'  , 'Vukovic'    , 1992,  null     ),
(20100026, 'Zorica'  , 'Miladinovic', 1993, 'Vranje'  ),
(20100027, 'Milena'  , 'Stankovic'  , null,  null     );

select * from dosije;


-- Ako zelimo da isforsirmo uslov da ne postoje dva studenta
-- sa istim imenom mozemo da definisemo jedinstveni indeks 

-- na nekim sistemima se indeks brise automatski kada se obrise objekat
-- nad kojim je napravljen
drop index studime;

create unique index studime on dosije(ime);

insert into dosije(indeks,ime,prezime,god_rodjenja,mesto_rodjenja) values
(20100025, 'Marijana', 'Savkovic'   , 1991, 'Kraljevo');

insert into dosije(indeks,prezime,god_rodjenja,mesto_rodjenja,tekuci_prosek,drzava_rodjenja) values
(20100025, 'Marijana',   1991, 'Kraljevo',8.34,null);


select * 
from   dosije;


create table predmet (
       id_predmeta     integer      not null,
       sifra           varchar(5)           ,
       naziv           varchar(40)          ,
       bodovi          smallint             ,       
       primary key(id_predmeta)
);
-- ako se ne stavi IN tada se tabela smesta u predefinisani TS               
-- in stud2011.dugacak;
-- na nekim sistemima je   IN dbname.tsname;

insert into predmet values
(1001, 'M111', 'Analiza 1', 6)                          ,
(1002, 'M112', 'Analiza 2', 6)                          ,
(1003, 'M113', 'Analiza 3', 6)                          ,
(1021, 'M131', 'Geometrija', 6)                         ,
(1101, 'M105', 'Diskretne strukture 1', 6)              ,
(1102, 'M106', 'Diskretne strukture 2', 6)              ,
(2001, 'P101', 'Programiranje 1', 8)                    ,
(2002, 'P102', 'Programiranje 2', 8)                    ,
(2003, 'P103', 'Objektno orijentisano programiranje', 6),
(2004, 'P104', 'Algoritmi i strukture podataka', 6)     ,
(3001, 'S1'  , 'Engleski jezik 1', 5)                   ,
(3002, 'S2'  , 'Engleski jezik 2', 5)                   ,
(4001, 'R101', 'Uvod u organizaciju racunara', 5)       ,
(4002, 'R102', 'Uvod u Veb i Internet tehnologije', 5)  ;

select * 
from   predmet;


create table ispitni_rok (
       godina_roka     smallint     not null,
       oznaka_roka     varchar(5)   not null,
       naziv           varchar(15)  not null,
       pocetak_prij    date         not null,
       kraj_prij       date         not null,
       tip             char         not null with default 'B'
                constraint chk_tiproka
                check( tip in ('1','2','B','X')),
                -- '1' - samo predmeti iz 1. semestra
                -- '2' - samo predmeti iz 2. semestra
                -- 'B' - predmeti iz oba semestra
                -- 'X' - samo po jedan predmet, ako je poslednji nepolozen
-- alternativa: 
        tip1          char(1)       check  (tip1 in ('1','2','B','X')),
        tip2          char(1)       with default 'B' check  (tip2 in ('1','2','B','X')),
       primary key (godina_roka, oznaka_roka)
);
insert into ispitni_rok values
(2011, 'jan', 'Januar 2011','12.01.2011','26.01.2011','1')   ,
(2011, 'feb', 'Februar 2011','20.01.2011','14.02.2011','1')  ,
(2011, 'apr', 'April 2011','12.03.2011','26.03.2011','1')    ,
(2011, 'jun', 'Jun 2011','12.05.2011','26.05.2011','2')      ,
(2011, 'sep', 'Septembar 2011','25.06.2011','22.08.2011','B'),
(2011, 'okt', 'Oktobar 2011','06.09.2011','15.09.2011','2')  ;


insert into ispitni_rok (godina_roka,oznaka_roka,naziv,pocetak_prij,kraj_prij,tip) values
(2011, 'jan', 'Januar 2011','12.01.2011','26.01.2011','1')   ,
(2011, 'feb', 'Februar 2011','20.01.2011','14.02.2011','1')  ,
(2011, 'apr', 'April 2011','12.03.2011','26.03.2011','1')    ,
(2011, 'jun', 'Jun 2011','12.05.2011','26.05.2011','2')      ,
(2011, 'sep', 'Septembar 2011','25.06.2011','22.08.2011','B'),
(2011, 'okt', 'Oktobar 2011','06.09.2011','15.09.2011','2')  ;


select * 
from ispitni_rok;

create distinct type datum    as date with comparisons;
create distinct type vreme    as time with comparisons;

create table ispit (
       indeks          integer      not null                        ,
       id_predmeta     integer      not null                        ,
       godina_roka     smallint     not null                        ,
       oznaka_roka     char(5)      not null                        ,
       ocena           smallint     not null with default 5         ,
       datum_ispita    datum                                        ,
       vreme_ispita    vreme                                        ,
       rbr_prijave     integer      not null generated always
                                    as identity (start with 1)      ,
       primary key (indeks, id_predmeta, godina_roka, oznaka_roka,rbr_prijave),
       foreign key (godina_roka, oznaka_roka) references ispitni_rok,
       constraint indeks_ref foreign key (indeks) references dosije ,
       foreign key (id_predmeta)              references predmet)   ;


--create unique index indispit on ispit(indeks, id_predmeta, godina_roka, oznaka_roka,rbr_prijave);
--U nekim verzijama se primarni indeks ne formira automatski! 
--Definisisanje spoljašnjih ključeva onemogućuje unos nekonzistentnih podataka 

insert into ispit(indeks, id_predmeta, godina_roka, oznaka_roka, ocena, datum_ispita)  values 
(20100021, 1001, 2011, 'jan', 9, date('20.01.2011')),
(20100022, 1001, 2011, 'jan', 8, date('20.01.2011')),
(20100023, 1001, 2011, 'jan', 8, date('20.01.2011')),
(20100024, 1001, 2011, 'jan', 10,date('20.01.2011')),
(20100025, 1001, 2011, 'jan', 6, date('20.01.2011')),
(20100026, 1001, 2011, 'jan', 5, date('20.01.2011')),

(20100021, 2001, 2011, 'jan', 10,date('25.01.2011')),
(20100022, 2001, 2011, 'jan', 9, date('25.01.2011')),
(20100023, 2001, 2011, 'jan', 8, date('25.01.2011')),
(20100024, 2001, 2011, 'jan', 7, date('25.01.2011')),
(20100025, 2001, 2011, 'jan', 5, date('25.01.2011'));

insert into ispit(indeks, id_predmeta, godina_roka, oznaka_roka, ocena, datum_ispita)  values 
(20100031, 1001, 2011, 'jan', 9, date('20.01.2011')),
(20100032, 1001, 2011, 'jan', 8, date('20.01.2011'));


insert into ispit(indeks, id_predmeta, godina_roka, oznaka_roka, ocena, datum_ispita)  values 
(20100021, 1001, 2018, 'jan', 9, date('20.01.2011')),
(20100022, 1001, 2017, 'nov', 8, date('20.01.2011'));


insert into ispit(indeks, id_predmeta, godina_roka, oznaka_roka, datum_ispita,vreme_ispita)  values 
(20100022, 1021, 2011, 'apr',    date('03.04.2011'),current_time),
(20100024, 1021, 2011, 'apr',    current_date,current_time); 

insert into ispit(indeks, id_predmeta, godina_roka, oznaka_roka, ocena,datum_ispita,vreme_ispita,rbr_prijave)  values 
(20100026, 1021, 2011, 'apr', 8,current_date,current_time,16)              ;


insert into ispit(indeks, id_predmeta, godina_roka, oznaka_roka, ocena, datum_ispita)  values 
(20100021, 3001, 2011, 'jan', 7, date('27.01.2011')),
(20100023, 3001, 2011, 'jan', 5, date('27.01.2011')),
(20100024, 3001, 2011, 'jan', 6, date('28.01.2011')),
(20100026, 3001, 2011, 'jan', 6, date('28.01.2011')),

(20100026, 1001, 2011, 'feb', 7, date('10.02.2011')),

(20100025, 2001, 2011, 'feb', 6, date('10.02.2011')),
(20100026, 2001, 2011, 'feb', 7, date('10.02.2011')),

(20100021, 1021, 2011, 'apr', 7, date('03.04.2011')),
(20100023, 1021, 2011, 'apr', 10,date('03.04.2011'));

select * 
from ispit;
