--connect to stud2020;

-- Ilustracija referencijalnog ciklusa: 

drop table dosije_parlament;

create table dosije_parlament  (
       indeks           integer      not null,  
       ime              varchar(10)  not null with default USER,
       prezime          varchar(15)  not null,
       god_rodjenja     smallint             ,        
       mesto_rodjenja   varchar(20)          ,
       tekuci_prosek    prosek       not null with default 0,
       drzava_rodjenja  drzava                with default 'Srbija',
       predstavnik_ind  integer              ,
       primary key      (indeks)             ,
       check  (indeks/10000>=2010)
);

insert into dosije_parlament(indeks,ime,prezime,god_rodjenja,mesto_rodjenja, tekuci_prosek,drzava_rodjenja) 
select indeks,ime,prezime,god_rodjenja,mesto_rodjenja, tekuci_prosek,drzava_rodjenja from dosije; 

select * from dosije_parlament;

alter table dosije_parlament add constraint predstavnikgrupe
      foreign key (predstavnik_ind)  
      references dosije_parlament(indeks) on delete cascade;

update dosije_parlament set predstavnik_ind=(select min(indeks) from dosije)
where  indeks=(select max(indeks) from dosije);

select * from dosije_parlament;

--Upit neće biti uspešno izvršen jer student sa indeksom 20000101 ne postoji u tabeli dosije_parlament
update dosije_parlament set predstavnik_ind=20000101;

--Upit će biti uspešno izvršen jer student sa indeksom 20100021 postoji u tabeli dosije_parlament
update dosije_parlament set predstavnik_ind=20100021;

select * from dosije_parlament;
