--Neke agregatne funkcije

--Naci ukupan broj studenata koji su upisani skolske 2013/2014. godine. 

select 'Ukupan broj upisanih studenata skolske 2013/2014 godine je',
       count(*)
from   dosije
where indeks/10000=2013;



--Prikazati datume kada su polagani ispiti i ukupan broj studenata koji su 
--tog datuma polagali neki od ispita

select datum_ispita,count(*) as "Broj studenata koji su polagali"
from   ispit
group  by datum_ispita;


--Neka je student obavezan da se pojavi na predavanjima najkasnije 
--4 dana posle zavrsetka poslednjeg ispita u nekom ispitnom roku. 
--Prikazati, za svaki rok u 2015. godini koji su bili datumi do kada je
--student mogao da ne dolazi na aktivnosti drzane posle tog ispitnog roka. 
--Ukoliko datum polaganja ispita nije poznat, u tom slucaju prikazati 
--'Nije mogao da odsustvuje'. Izvestaj urediti po ispitnim rokovima u 
--obrnutom redosledu i brojevima indeksa


select oznaka_roka,
       indeks,
       char(max(datum_ispita + 3 days)) 
       -- mogao je da odsustvuje 3 dana jer je morao da se 
       -- pojavi najaksnije 4 dana posle poslednjeg ispita
from   ispit
where  godina_roka=2015
and    datum_ispita is not null
group  by oznaka_roka,indeks

union all 

select oznaka_roka,indeks,'Nije mogao da odsustvuje'
from   ispit
where  godina_roka=2015
and    datum_ispita is null
group  by oznaka_roka,indeks
order by oznaka_roka;


--Prikazati ime i prezime studenta i ukupan broj bodova koje je 
--student do sada sakupio

select ime as "Ime", prezime as "Prezime", sum(c.bodovi) as "Položio bodova"
from   dosije a, ispit b, predmet c
where  a.indeks=b.indeks
and    b.id_predmeta=c.id_predmeta
and    ocena>5
group  by ime,prezime;


--Naci stvarnu duzinu januarskog ispitnog roka 2015. godine, 
--tj. interval od kada do kada su polagani ispiti u tom roku

select 'Ispiti u januarskom ispitnom roku 2015. godine su polagani od',
       min(datum_ispita),' do ',max(datum_ispita)
from   ispit
where  godina_roka=2015
and    oznaka_roka='jan';


--Za svakog studenta prikazati ime, prezime, broj indeksa, 
--najmanju ocenu, najvecu ocenu, prosecnu ocenu, standardnu devijaciju 
--i varijansu ocena koje je dobio na ispitima u skolskoj 2013/2014., 
--ukljucujuci i ispite na kojima je pao. 

select ime,prezime,a.indeks,max(ocena) as "Najveca ocena",
       min(ocena) as "Najmanja ocena", 
       avg(ocena) as "Prosecna ocena",
       avg(ocena*1.0) as "Prosek ocena*1.0",
       dec(avg(ocena),7,2) as "dec(prosek ocena),7,2)",
       round(avg(dec(ocena,7,2)),2) as "Zaokruzena prosecna decimalna vrednost ocene" ,
       dec(round(avg(dec(ocena,7,4)),2),7,2) as "Zaokruzena prosecna decimalna vrednost ocene prikazana na dve decimale" ,       
       stddev(ocena) as "Stddev(ocena)",
       variance(ocena) as "Variance(ocena)"
from   dosije a, ispit b
where  a.indeks=b.indeks
group  by ime,prezime,a.indeks;
--ZADATAK: DODATI U PRETHODNI UPIT USLOV DA SU ISPITI POLAGANI U 2013/2014 ŠKOLSKOJ GODINI

--Ispitati da li postoji korelacija izmedju broja indeksa studenta i 
--ocene koju je dobio na ispitu

select correlation(indeks,ocena)
from ispit;


--Prikazati imena i prezimena studenata koji su polozili bar dva ispita sa
--ocenom vecom od 7. Izvestaj urediti po imenima i prezimenima studenata

select ime,prezime,a.indeks
from   dosije a, ispit b
where  a.indeks=b.indeks
and    ocena>7
group  by ime,prezime,a.indeks
having count(*)>1
order by ime,prezime;

--Prikazati nisku koja sadrzi imena studenata uredjena prema godini njihovog rodjenja.

select listagg(ime,' ,') WITHIN GROUP (ORDER BY DATUM_RODJENJA)
from   dosije a;
