drop table aminoacids;


       
create table aminoacids (
        name           character(27) not null,
        code1          character(1)  not null,        
        code3          character(3)  not null,
        codons         smallint      not null,
        code3u         character(3)  not null,
        kdhidrotip     character(11) not null,                    
        kdhidrofobnost decimal (2,1) not null,
        kdhydrophobic  character(2)  not null,        
        hwhidrotip     character(11) not null,                    
        hwhidrofobnost decimal (2,1) not null,        
        hwhydrophobic  character(2)  not null,        
        polar          character(2)  not null,
        largesmall     character(2)  not null,
        aliphatic      character(2)  not null,
        aromatic       character(2)  not null,	
        tiny           character(2)  not null,
        charged        character(2)  not null,
        positive       character(2)  not null,
        negative       character(2)  not null,
        largehidr      character(2)  not null,
        proline        character(2)  not null,        
        redosled       smallint      not null,
        redosledc      char(2)       not null,
        redosled1      smallint      not null with default 0,
        redosledu      char(2)       not null with default '  ',
        primary        key (code1)
       ); 

LOAD FROM aminoacids.load OF DEL MODIFIED BY COLDEL, FASTPARSE METHOD  
P (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23) 
MESSAGES aminoacids.load.izv INSERT INTO 
aminoacids(name,code1,code3,codons,code3u,
           kdhidrotip,kdhidrofobnost,kdhydrophobic,
           hwhidrotip,hwhidrofobnost,hwhydrophobic,
           polar,largesmall,aliphatic,aromatic,tiny,
           charged,positive,negative,largehidr,
           proline,redosled,redosledc)
NONRECOVERABLE INDEXING MODE AUTOSELECT;        

-- redosled je prema disordeicnosti W, F, Y, I, M, L, V, N, C, T, A, G, R, D, H, Q, K, S, E, P (Campen et al. 2008)
--update aminoacids set redosled=1  where code1='W';
--update aminoacids set redosled=2  where code1='F';
--update aminoacids set redosled=3  where code1='Y';
--update aminoacids set redosled=4  where code1='I';
--update aminoacids set redosled=5  where code1='M';
--update aminoacids set redosled=6  where code1='L';
--update aminoacids set redosled=7  where code1='V';
--update aminoacids set redosled=8  where code1='N';
--update aminoacids set redosled=9  where code1='C';
--update aminoacids set redosled=10 where code1='T';
--update aminoacids set redosled=11 where code1='A';
--update aminoacids set redosled=12 where code1='G';
--update aminoacids set redosled=13 where code1='R';
--update aminoacids set redosled=14 where code1='D';
--update aminoacids set redosled=15 where code1='H';
--update aminoacids set redosled=16 where code1='Q';
--update aminoacids set redosled=17 where code1='K';
--update aminoacids set redosled=18 where code1='S';
--update aminoacids set redosled=19 where code1='E';
--update aminoacids set redosled=20 where code1='P';
--update aminoacids set redosledc=' '||rtrim(char(redosled)) where redosled<10;
--update aminoacids set redosledc=rtrim(char(redosled)) where redosled>=10;
-- redosled je prema disordeicnosti C, W, Y, I, F, V, L, H, T, N, A, G, D, M, K, R, S, Q, P, E (Johnny Habchi, Peter Tompa, Sonia Longhi, and Vladimir N. Uversky, 2013.: Introducing Protein Intrinsic Disorder)

update aminoacids set redosled1=1  where code1='C';
update aminoacids set redosled1=2  where code1='W';
update aminoacids set redosled1=3  where code1='Y';
update aminoacids set redosled1=4  where code1='I';
update aminoacids set redosled1=5  where code1='F';
update aminoacids set redosled1=6  where code1='V';
update aminoacids set redosled1=7  where code1='L';
update aminoacids set redosled1=8  where code1='H';
update aminoacids set redosled1=9  where code1='T';
update aminoacids set redosled1=10 where code1='N';
update aminoacids set redosled1=11 where code1='A';
update aminoacids set redosled1=12 where code1='G';
update aminoacids set redosled1=13 where code1='D';
update aminoacids set redosled1=14 where code1='M';
update aminoacids set redosled1=15 where code1='K';
update aminoacids set redosled1=16 where code1='R';
update aminoacids set redosled1=17 where code1='S';
update aminoacids set redosled1=18 where code1='Q';
update aminoacids set redosled1=19 where code1='P';
update aminoacids set redosled1=20 where code1='E';
update aminoacids set redosled1=redosled where redosled>20;
update aminoacids set redosledu=' '||rtrim(char(redosled1)) where redosled1<10;
update aminoacids set redosledu=rtrim(char(redosled1)) where redosled1>=10;

export to aminoacids.v11.load OF DEL MODIFIED BY NOCHARDEL COLDELX09 MESSAGES aminoacids.v11.export.izv select * from aminoacids;

RUNSTATS ON TABLE aminoacids ON ALL COLUMNS AND INDEXES ALL ALLOW WRITE ACCESS ;
