-- Prikazati sve korisnike koji imaju autorizaciju za čitanje ili ažuriranje podataka u tabeli DOSIJE u SHEMI DB, 
-- da li je ta autorizacija dalje prenopsiva, kao i identifikaciju nosioca koji im je dodelio tu autorizaciju. 


SELECT GRANTOR as "Vlasnik autorizacije", 
       GRANTEE as "Id kome je data autorizacija", 
       case selectauth  
            when 'Y' then 'Ima neprenosivu autorizaciju za čitanje'
            when 'G' then 'Ima autorizaciju za čitanje koju može da prenese'
            else          'Nema autorizaciju za čitanje'
       end,     
       case updateauth  
            when 'Y' then 'Ima neprenosivu autorizaciju za ažuriranje'
            when 'G' then 'Ima autorizaciju za ažuriranje koju može da prenese'
            else          'Nema autorizaciju za ažuriranje'
       end
from   syscat.tabauth                   
where  TABSCHEMA='DB'
and    TABNAME='DOSIJE'     
and    (selectauth in ('Y','G') or  updateauth in ('Y','G'));
