with preduslovi (nivo, id_programa, predmet, preko, uslovni_predmet) as
    ( 
--    Inicijalni SELECT

      select 0, idprograma, idpredmeta, null, iduslovnogpredmeta
      from   db.uslovnipredmet koren
      where  koren.idpredmeta in (select id from db.predmet where naziv='Релационе базе података')
      
      union all

--    Iterativni SELECT      
      select roditelj.nivo+1, roditelj.id_programa, roditelj.predmet, dete.idpredmeta, dete.iduslovnogpredmeta
      from   preduslovi roditelj, db.uslovnipredmet dete
      where  roditelj.uslovni_predmet=dete.idpredmeta
      and    roditelj.id_programa=dete.idprograma
      and    nivo<=10   -- uklanja poruku da je moća beskonačna petlja
    )
-- Glavni SELECT    
select distinct (select char(naziv||'-'||oznaka,51) from db.studijskiprogram b where b.id=a.id_programa) as "Studijski program",
                substr(char(nivo),1,4) as "Nivo" ,
                (select char(naziv,45) from db.predmet b where b.id=a.predmet) as "Predmet", 
                (select char(naziv,45) from db.predmet b where b.id=a.preko) as "Predmet preko koga je preduslov", 
                (select char(naziv,45) from db.predmet b where b.id=a.uslovni_predmet) as "Uslovni predmet",
                (select ESPB           from db.predmet b where b.id=a.uslovni_predmet) as "ESPB",               
                (select semestar       from db.predmetprograma b where b.idpredmeta=a.uslovni_predmet and b.idprograma=a.id_programa) as "Semestar"
from   preduslovi a

order by 1;

