drop table prosekocenapoispitnimrokovima;
create table prosekocenapoispitnimrokovima(predmet,godina_roka,oznaka_roka,prosek,polozio_pao,broj)
as
(
with polozio(predmet,godina_roka,oznaka_roka,prosek, broj)
as
 (
  select b.naziv, a.godina_roka, a.oznaka_roka, dec(avg(ocena*1.0),4,2), count(*)
  from   ispit a, predmet b
  where  a.id_predmeta=b.id_predmeta
  and    a.ocena>5
  group  by b.naziv, a.godina_roka, a.oznaka_roka
 ), 
     pao(predmet,godina_roka,oznaka_roka,prosek, broj)
as
 (
  select b.naziv, a.godina_roka, a.oznaka_roka, dec(avg(ocena*1.0),4,2), count(*)
  from   ispit a, predmet b
  where  a.id_predmeta=b.id_predmeta
  and    a.ocena=5
  group  by b.naziv, a.godina_roka, a.oznaka_roka
 )


 
select predmet,godina_roka,oznaka_roka,prosek,'polozilo', broj
from   polozio

union all 

select predmet,godina_roka,oznaka_roka,prosek,'palo', broj
from   pao
)

data initially deferred
  refresh deferred;
--refresh immediate;  -- uz proveru da li su zadovoljeni potrebni uslovi

--Za inicijalno punjene i/ili osvežavanje sadržaja MQT tabele izvršiti 

--refresh table prosekocenapoispitnimrokovima
--allow no access; 

--select * from prosekocenapoispitnimrokovima



-- Posle izvršavanja pogledati: 
-- a) SYSCAT.TABLES    - pogled
-- b) SYSIBM.SYSTABLES - tabela          
