--Za svakog studenta, izračunati prosečan prosek ocena u grupi studenata koji imaju broj indeksa za jedan veći i jedan manji od tog studenta
-- Za dodatni test, u tabelu ispita i dosijea uneti nove slogove tako da postoje po tri kontinuirana indeksa

with proseci(indeks, ime, prezime, prosek)
as
(
 select a.indeks, ime, prezime, dec(avg(ocena*1.0),4,2)
 from   ispit a, dosije b 
 where  ocena >5
 and    a.indeks=b.indeks
 and    a.datum_ispita=(select max(datum_ispita)
                        from   ispit c
                        where  a.indeks=c.indeks
                        and    a.id_predmeta=c.id_predmeta 
                       )
 group by a.indeks,ime,prezime
)
select indeks,ime, prezime, prosek, dec(avg(prosek) over (order by indeks range BETWEEN 1 PRECEDING AND 1 FOLLOWING),4,2) as "Prosek grupe"
from   proseci;





--Za svakog studenta, izračunati prosečan prosek ocena u grupi studenata čiji je broj indeksa manji za 1, 2 ili 3 u odnosu na broj njregovog indeksa, kao i 
--prosečan prosek ocena u grupi studenata uključujući i tog studenta i studente sa brojevima indeks akoji su za 1 ili 2 manji od njegovog.

with proseci(indeks, ime, prezime, prosek)
as
(
 select a.indeks, ime, prezime, dec(avg(ocena*1.0),4,2)
 from   ispit a, dosije b 
 where  ocena >5
 and    a.indeks=b.indeks
 and    a.datum_ispita=(select max(datum_ispita)
                        from   ispit c
                        where  a.indeks=c.indeks
                        and    a.id_predmeta=c.id_predmeta 
                       )
 group by a.indeks,ime,prezime
)

select indeks,ime, prezime, prosek, dec(avg(prosek) over (order by indeks range BETWEEN 3 PRECEDING AND 1 PRECEDING),4,2) as "Prosek - br. indeksa manji za 3",
                                    dec(avg(prosek) over (order by indeks range BETWEEN 2 PRECEDING AND CURRENT ROW),4,2) as "Prosek - uključen student"
from   proseci;

