-- Odrediti redosled studenta u zavisnosti od trenutnog proseka njihovih ocena

with proseci(indeks, ime, prezime, prosek)
as
(
 select a.indeks, ime, prezime, dec(avg(ocena*1.0),4,2)
 from   ispit a, dosije b 
 where  ocena >5
 and    a.indeks=b.indeks
 and    a.datum_ispita=(select max(datum_ispita)
                        from   ispit c
                        where  a.indeks=c.indeks
                        and    a.id_predmeta=c.id_predmeta 
                       )
 group by a.indeks,ime,prezime
)
select indeks,ime, prezime, prosek, dense_rank() over(order by prosek desc) as "Redosled"
from   proseci 
--order  by indeks; 
--order by dense_rank() over(order by prosek desc)




-- Rangirati studente prema mestu rodjenja i trenutnom proseku ocena. U svakom mestu rangiranje studenata započeti od pozicije 1 za studenta sa najvećim prosekom

with proseci(indeks, ime, prezime, mesto_rodjenja, prosek)
as
(
 select a.indeks, ime, prezime, mesto_rodjenja, dec(avg(ocena*1.0),4,2)
 from   ispit a, dosije b 
 where  ocena >5
 and    a.indeks=b.indeks
 and    a.datum_ispita=(select max(datum_ispita)
                        from   ispit c
                        where  a.indeks=c.indeks
                        and    a.id_predmeta=c.id_predmeta 
                       )
 group by a.indeks,ime,prezime,mesto_rodjenja
)

SELECT indeks,ime,prezime,mesto_rodjenja, prosek,
DENSE_RANK() OVER (PARTITION BY mesto_rodjenja ORDER BY prosek DESC) AS "Redosled"
FROM proseci;

