with preduslovi (nivo, predmet, preko, uslovni_predmet) as
    ( 
--    Inicijalni SELECT

      select 0, koren.id_predmeta, null, id_uslovnog
      from   uslovni_predmet koren
      where  koren.id_predmeta in (select id_predmeta from predmet where naziv='Relacione baze podataka')
      
      union all

--    Iterativni SELECT      
      select roditelj.nivo+1, roditelj.predmet, dete.id_predmeta, dete.id_uslovnog
      from   preduslovi roditelj, uslovni_predmet dete
      where  roditelj.uslovni_predmet=dete.id_predmeta
      and    nivo<=10   -- uklanja poruku da je moguća beskonačna petlja      
    )
-- Glavni SELECT    
select distinct 
       char(char(nivo),4) as "Nivo",
       (select char(naziv,30) from predmet b where b.id_predmeta=a.predmet) as "Predmet", 
       (select char(naziv,30) from predmet b where b.id_predmeta=a.preko) as "Predmet preko koga je preduslov", 
       (select char(naziv,30) from predmet b where b.id_predmeta=a.uslovni_predmet) as "Uslovni predmet",
       (select bodovi         from predmet b where b.id_predmeta=a.uslovni_predmet) as "ESPB"                
from   preduslovi a

order by 1;
